/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.DeploymentException;
import electric.application.IApplication;
import electric.application.tools.Utils;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;

public class Enable {
    private static String appName;
    private static String servletName;
    private static String serviceName;
    private static String servicesURL;

    public static void main(String[] args) {
        if (args.length == 0) {
            Enable.printUsage();
            return;
        }
        try {
            Enable.processArgs(args);
            Enable.enable();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Enable.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: enable [-Dname=value]* [-h] {appname | url} {-s service-path | -v servlet-name}");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value    = set java system property");
        System.out.println("  appname         = local application name");
        System.out.println("  url             = remote application service root");
        System.out.println("  -h              = print help and exit");
        System.out.println("  -s service-path = registry path of service to enable");
        System.out.println("  -v servlet-name = name of servlet (from web.xml) to enable");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("enable app1 -s sample");
        System.out.println("  enable service with path /sample in local application app1");
        System.out.println();
        System.out.println("enable http://host:9000/app2/services -s finance/stock");
        System.out.println("  enable service with path /finance/stock in remote application app2");
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (appName != null) {
                    throw new IllegalArgumentException("more than one appname/url supplied");
                }
                appName = arg;
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        Enable.printUsage();
                        System.exit(-1);
                    }
                    case 's': {
                        serviceName = Strings.getString("s", args, ++i);
                        break;
                    }
                    case 'v': {
                        servletName = Strings.getString("v", args, ++i);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (appName == null) {
            throw new IllegalArgumentException("missing appname/url");
        }
        if (serviceName == null && servletName == null) {
            throw new IllegalArgumentException("missing service path or servlet name argument");
        }
        servicesURL = Utils.getServicesURL(appName);
    }

    private static void enable() throws DeploymentException {
        IApplication application = Utils.bindToApplication(servicesURL);
        if (serviceName != null) {
            application.enableService(serviceName);
        } else {
            application.enableServlet(servletName);
        }
    }
}

