/*
 * Decompiled with CFR 0.152.
 */
package electric.application.simple;

import electric.application.Application;
import electric.application.DeploymentException;
import electric.application.ServicesSummary;
import electric.application.web.servlets.ServletDescriptor;
import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.INeedInstantiator;
import electric.service.IService;
import electric.service.descriptor.ServiceDescriptor;
import electric.util.fileloader.filesystem.FileSystemLoader;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.xml.Element;
import java.io.IOException;

public class SimpleApplication
extends Application {
    public SimpleApplication(Element config) {
        this.setAppName("simple");
        this.setConfig(config);
        this.setFileLoader(new FileSystemLoader());
    }

    public void addServiceUsingDescriptor(String path, ServiceDescriptor descriptor) throws DeploymentException {
        if (descriptor == null) {
            throw new DeploymentException(this.getAppName() + ": cannot add service " + path + " because descriptor is null");
        }
        if (!descriptor.publish) {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": service " + path + " is disabled"));
            }
            return;
        }
        try {
            descriptor.setClassLoader(null);
            IService service = Registry.getServiceFactory().newService(descriptor.getObject());
            if (service instanceof INeedInstantiator) {
                ((INeedInstantiator)((Object)service)).setInstantiator(descriptor.instantiator);
            }
            Registry.publish(path, (Object)service, descriptor.getContext());
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": added service " + path));
            }
        }
        catch (Throwable throwable) {
            throw new DeploymentException(throwable.toString());
        }
    }

    public boolean removeService(String path) throws DeploymentException {
        try {
            Registry.unpublish(path);
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": removed service " + path));
            }
            return true;
        }
        catch (RegistryException exception) {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, this.getAppName() + ": cannot remove service " + path, exception);
            }
            throw new DeploymentException(exception.toString());
        }
    }

    public void addService(String path, MIMEData descriptor) throws DeploymentException {
        throw new DeploymentException("adding services with mimedata descriptor is not supported");
    }

    public void enableService(String name) throws DeploymentException {
        throw new DeploymentException("enabling services is not supported");
    }

    public void disableService(String name) throws DeploymentException {
        throw new DeploymentException("disabling services is not supported");
    }

    public String[] getServicePaths() {
        return new String[0];
    }

    public ServicesSummary getServicesSummary() throws DeploymentException {
        throw new DeploymentException("retrieving services summary is not supported");
    }

    public void addServlet(String name, String className, String urlPattern) throws DeploymentException {
        throw new DeploymentException("adding servlets is not supported");
    }

    public boolean removeServlet(String name) throws DeploymentException {
        throw new DeploymentException("removing servlets is not supported");
    }

    public void enableServlet(String name) throws DeploymentException {
        throw new DeploymentException("enabling servlets is not supported");
    }

    public void disableServlet(String name) throws DeploymentException {
        throw new DeploymentException("disabling servlets is not supported");
    }

    public String[] getServletNames() throws DeploymentException {
        throw new DeploymentException("retrieving servlet names is not supported");
    }

    public ServletDescriptor getServletDescriptor(String servletName) throws DeploymentException {
        throw new DeploymentException("retrieving servlet descriptor is not supported");
    }

    public void addJar(String filename, MIMEData jar) throws DeploymentException {
        throw new DeploymentException("adding jars is not supported");
    }

    public boolean removeJar(String filename) throws DeploymentException {
        throw new DeploymentException("removing jars is not supported");
    }

    public void uploadApplication(MIMEData jar) throws DeploymentException, IOException {
        throw new DeploymentException("uploading updates is not supported");
    }

    public void deleteFiles(String[] filenames) {
        throw new UnsupportedOperationException("deleting application files is not supported");
    }
}

