/*
 * Decompiled with CFR 0.152.
 */
package com.infomata.data;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class DataRow {
    private Hashtable index = null;
    private ArrayList items = null;
    private NumberFormat nf = null;
    private SimpleDateFormat df = new SimpleDateFormat();

    public DataRow() {
        this.items = new ArrayList();
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(50);
    }

    public DataRow(NumberFormat format) {
        this.items = new ArrayList();
        this.nf = format;
    }

    public void add(String datum) {
        this.items.add(datum);
    }

    public void add(int datum) {
        this.items.add(this.nf.format(datum));
    }

    public void add(long datum) {
        this.items.add(this.nf.format(datum));
    }

    public void add(double datum) {
        this.items.add(this.nf.format(datum));
    }

    public void add(Object obj) {
        String str = obj.toString();
        this.add(str);
    }

    public void addEmpty() {
        this.items.add("");
    }

    public Iterator iterator() {
        return this.items.iterator();
    }

    public Date getDate(int location, String pattern) {
        Date d = null;
        String v = this.getString(location).trim();
        try {
            this.df.applyPattern(pattern);
            d = this.df.parse(v);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return d;
    }

    public java.sql.Date getSqlDate(int location, String pattern) {
        java.sql.Date d = null;
        String v = this.getString(location).trim();
        try {
            this.df.applyPattern(pattern);
            d = new java.sql.Date(this.df.parse(v).getTime());
        }
        catch (ParseException e) {
            // empty catch block
        }
        return d;
    }

    public Date getDate(String label, String pattern) {
        Date d = null;
        int idx = this.getIndex(label);
        if (idx >= 0) {
            d = this.getDate(idx, pattern);
        }
        return d;
    }

    public double getDouble(int location) throws NumberFormatException {
        double d = Double.NaN;
        String val = this.getString(location).trim();
        try {
            d = this.nf.parse(val).doubleValue();
        }
        catch (ParseException e) {
            try {
                d = Double.valueOf(val);
            }
            catch (Exception l) {
                throw new NumberFormatException(l.getMessage());
            }
        }
        return d;
    }

    public double getDouble(String label) throws NumberFormatException {
        double d = 0.0;
        int idx = this.getIndex(label);
        if (idx < 0) {
            throw new NumberFormatException("cannot parse null - check label");
        }
        d = this.getDouble(idx);
        return d;
    }

    public double getDouble(int location, double defaultVal) {
        String val = this.getString(location).trim();
        try {
            defaultVal = this.nf.parse(val).doubleValue();
        }
        catch (ParseException e) {
            try {
                defaultVal = Double.valueOf(val);
            }
            catch (NumberFormatException l) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public double getDouble(int location, DecimalFormat format, double defaultVal) {
        String val = this.getString(location).trim();
        try {
            defaultVal = format.parse(val).doubleValue();
        }
        catch (ParseException e) {
            try {
                defaultVal = Double.valueOf(val);
            }
            catch (NumberFormatException nf) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public double getDouble(String label, double defaultVal) {
        int idx = this.getIndex(label);
        if (idx >= 0) {
            defaultVal = this.getDouble(idx, defaultVal);
        }
        return defaultVal;
    }

    public int getInt(int location) throws NumberFormatException {
        int i = 0;
        String val = this.getString(location).trim();
        try {
            i = this.nf.parse(val).intValue();
        }
        catch (Exception e) {
            try {
                i = Integer.parseInt(val);
            }
            catch (Exception l) {
                new NumberFormatException(l.getMessage());
            }
        }
        return i;
    }

    public int getInt(String label) throws NumberFormatException {
        int i = 0;
        int idx = this.getIndex(label);
        if (idx < 0) {
            throw new NumberFormatException("cannot parse null - check label");
        }
        i = this.getInt(idx);
        return i;
    }

    public int getInt(int location, int defaultVal) {
        String val = this.getString(location).trim();
        try {
            defaultVal = this.nf.parse(val).intValue();
        }
        catch (ParseException e) {
            try {
                defaultVal = Integer.parseInt(val);
            }
            catch (Exception l) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public int getInt(int location, DecimalFormat format, int defaultVal) {
        String val = this.getString(location).trim();
        try {
            defaultVal = format.parse(val).intValue();
        }
        catch (ParseException e) {
            try {
                defaultVal = Integer.parseInt(val);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public int getInt(String label, int defaultVal) {
        int idx = this.getIndex(label);
        if (idx >= 0) {
            defaultVal = this.getInt(idx, defaultVal);
        }
        return defaultVal;
    }

    public String getString(int location) {
        String s = "";
        try {
            s = (String)this.items.get(location);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return s;
    }

    public String getString(String label) {
        String s = "";
        int idx = this.getIndex(label);
        if (idx >= 0) {
            s = this.getString(idx);
        }
        return s;
    }

    public String getString(int location, String defaultVal) {
        try {
            String tmp = (String)this.items.get(location);
            if (tmp.length() != 0) {
                defaultVal = tmp;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return defaultVal;
    }

    public String getString(String label, String defaultVal) {
        int idx = this.getIndex(label);
        if (idx >= 0) {
            defaultVal = this.getString(idx, defaultVal);
        }
        return defaultVal;
    }

    void setHeaderIndex(Hashtable index) {
        this.index = index;
    }

    public int size() {
        return this.items.size();
    }

    private int getIndex(String label) {
        Integer idx;
        int loc = -1;
        if (this.index != null && (idx = (Integer)this.index.get(label)) != null) {
            loc = idx;
        }
        return loc;
    }

    public String toString() {
        StringBuffer o = new StringBuffer("[DataRow]");
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            o.append("|'").append((String)i.next()).append("'");
        }
        return o.toString();
    }

    public void clear() {
        this.items.clear();
    }
}

