/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.value.directory;

import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public abstract class SynchronisableDirectoryConnection {
    private SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth syncGroupMembershipsAfterAuth = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.DEFAULT;
    private boolean incrementalSyncEnabled = false;
    private long pollingIntervalInMin = 60L;

    public void loadFromDirectory(Directory directory) {
        this.incrementalSyncEnabled = Boolean.parseBoolean(directory.getValue("crowd.sync.incremental.enabled"));
        this.pollingIntervalInMin = this.getAttributeValueAsLong(directory, "directory.cache.synchronise.interval") / 60L;
        this.syncGroupMembershipsAfterAuth = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)directory);
    }

    public void updateDirectory(DirectoryImpl directory) {
        directory.setAttribute("crowd.sync.incremental.enabled", Boolean.toString(this.incrementalSyncEnabled));
        directory.setAttribute("directory.cache.synchronise.interval", Long.toString(this.pollingIntervalInMin * 60L));
        directory.setAttribute("crowd.sync.group.membership.after.successful.user.auth.enabled", this.syncGroupMembershipsAfterAuth.getValue());
    }

    protected long getAttributeValueAsLong(Directory directory, String attributeName) {
        String value = directory.getValue(attributeName);
        return value == null ? 0L : Long.parseLong(value);
    }

    public boolean isIncrementalSyncEnabled() {
        return this.incrementalSyncEnabled;
    }

    public void setIncrementalSyncEnabled(boolean incrementalSyncEnabled) {
        this.incrementalSyncEnabled = incrementalSyncEnabled;
    }

    public long getPollingIntervalInMin() {
        return this.pollingIntervalInMin;
    }

    public void setPollingIntervalInMin(long pollingIntervalInMin) {
        this.pollingIntervalInMin = pollingIntervalInMin;
    }

    public String getSyncGroupMembershipsAfterAuth() {
        return this.syncGroupMembershipsAfterAuth.name();
    }

    public void setSyncGroupMembershipsAfterAuth(String syncGroupMembershipsAfterAuth) {
        this.syncGroupMembershipsAfterAuth = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.valueOf((String)syncGroupMembershipsAfterAuth);
    }

    public Map<String, String> getSyncGroupMembershipsAfterAuthValues() {
        return ImmutableMap.of((Object)SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.WHEN_AUTHENTICATION_CREATED_THE_USER.name(), (Object)"directoryconnector.update.groups.on.auth.whencreated.label", (Object)SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.NEVER.name(), (Object)"directoryconnector.update.groups.on.auth.never.label", (Object)SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS.name(), (Object)"directoryconnector.update.groups.on.auth.always.label");
    }
}

