/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.event;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class AliasEvent
implements OperationEvent {
    private final Operation operation;
    private final Application application;
    private final String username;
    @Nullable
    private final String newAlias;

    private AliasEvent(Operation operation, Application application, String username, @Nullable String newAlias) {
        this.operation = (Operation)((Object)Preconditions.checkNotNull((Object)((Object)operation)));
        this.application = (Application)Preconditions.checkNotNull((Object)application);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.newAlias = newAlias;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public Application getApplication() {
        return this.application;
    }

    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getNewAlias() {
        return this.newAlias;
    }

    @Override
    public Directory getDirectory() {
        return null;
    }

    public static AliasEvent created(Application application, String user, String newAlias) {
        return new AliasEvent(Operation.CREATED, application, user, newAlias);
    }

    public static AliasEvent updated(Application application, String user, String newAlias) {
        return new AliasEvent(Operation.UPDATED, application, user, newAlias);
    }

    public static AliasEvent deleted(Application application, String user) {
        return new AliasEvent(Operation.DELETED, application, user, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasEvent that = (AliasEvent)o;
        if (!this.application.equals(that.application)) {
            return false;
        }
        if (this.newAlias != null ? !this.newAlias.equals(that.newAlias) : that.newAlias != null) {
            return false;
        }
        if (this.operation != that.operation) {
            return false;
        }
        return this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.operation.hashCode();
        result = 31 * result + this.application.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + (this.newAlias != null ? this.newAlias.hashCode() : 0);
        return result;
    }
}

