/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryMonitorStarter {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryMonitorStarter.class);
    private final EventPublisher eventPublisher;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectoryManager directoryManager;

    public DirectoryMonitorStarter(EventPublisher eventPublisher, DirectoryInstanceLoader directoryInstanceLoader, DirectoryManager directoryManager) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.directoryInstanceLoader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)directoryInstanceLoader);
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void readyDirectoriesForSynchronization(ApplicationReadyEvent event) {
        logger.debug("Starting monitoring for all directories.");
        for (Directory directory : this.directoryManager.findAllDirectories()) {
            try {
                this.directoryInstanceLoader.getDirectory(directory);
            }
            catch (DirectoryInstantiationException e) {
                logger.error("Error loading directory " + directory.getName() + "[" + directory.getId() + "]", (Throwable)e);
            }
        }
        this.eventPublisher.unregister((Object)this);
    }
}

