/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.core.event;

import com.atlassian.crowd.core.event.DelegatingMultiEventPublisher;
import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareEventPublisher
extends DelegatingMultiEventPublisher
implements EventPublisher,
MultiEventPublisher {
    TransactionAwareEventPublisher(EventPublisher delegate) {
        super(delegate);
    }

    @Override
    public void publish(Object event) {
        if (this.shouldPostponeEvent()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createSynchronization(event));
        } else {
            this.delegate.publish(event);
        }
    }

    @Override
    public void publishAll(Collection<Object> events) {
        if (this.shouldPostponeEvent()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createSynchronization(events));
        } else {
            events.forEach(arg_0 -> ((EventPublisher)this.delegate).publish(arg_0));
        }
    }

    private boolean shouldPostponeEvent() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isSynchronizationActive();
    }

    private TransactionSynchronizationAdapter createSynchronization(final Object event) {
        return new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TransactionAwareEventPublisher.this.delegate.publish(event);
            }
        };
    }

    private TransactionSynchronizationAdapter createSynchronization(final Collection<Object> events) {
        return new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                events.forEach(arg_0 -> ((EventPublisher)TransactionAwareEventPublisher.this.delegate).publish(arg_0));
            }
        };
    }
}

