/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.Sha1ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.DefaultMetricsCollector;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClientIF;

public class MemcachedVCacheServiceSettingsBuilder {
    private Supplier<MemcachedClientIF> clientSupplier;
    private Supplier<RequestContext> contextSupplier;
    private VCacheSettingsDefaultsProvider defaultsProvider;
    private VCacheCreationHandler creationHandler;
    private MetricsCollector metricsCollector;
    private ExternalCacheKeyGenerator externalCacheKeyGenerator;
    private BegunTransactionalActivityHandler begunTransactionalActivityHandler = context -> {};
    private Function<String, Boolean> dontExternaliseCache = name -> false;

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder clientSupplier(Supplier<MemcachedClientIF> clientSupplier) {
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder contextSupplier(Supplier<RequestContext> contextSupplier) {
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder defaultsProvider(VCacheSettingsDefaultsProvider defaultsProvider) {
        this.defaultsProvider = Objects.requireNonNull(defaultsProvider);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder creationHandler(VCacheCreationHandler creationHandler) {
        this.creationHandler = Objects.requireNonNull(creationHandler);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder metricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder productIdentifier(String productIdentifier) {
        this.externalCacheKeyGenerator = new Sha1ExternalCacheKeyGenerator(productIdentifier);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder externalCacheKeyGenerator(ExternalCacheKeyGenerator externalCacheKeyGenerator) {
        this.externalCacheKeyGenerator = Objects.requireNonNull(externalCacheKeyGenerator);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder begunTransactionalActivityHandler(BegunTransactionalActivityHandler handler) {
        this.begunTransactionalActivityHandler = Objects.requireNonNull(handler);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettingsBuilder dontExternaliseCache(Function<String, Boolean> dontExternaliseCache) {
        this.dontExternaliseCache = Objects.requireNonNull(dontExternaliseCache);
        return this;
    }

    @Nonnull
    public MemcachedVCacheServiceSettings build() {
        return new MemcachedVCacheServiceSettings(Objects.requireNonNull(this.clientSupplier, "missing clientSupplier"), Objects.requireNonNull(this.contextSupplier, "missing contextSupplier"), Objects.requireNonNull(this.defaultsProvider, "missing defaultsProvider"), Objects.requireNonNull(this.creationHandler, "missing creationHandler"), (MetricsCollector)(this.metricsCollector != null ? this.metricsCollector : new DefaultMetricsCollector(this.contextSupplier)), Objects.requireNonNull(this.externalCacheKeyGenerator, "missing externalCacheKeyGenerator"), this.begunTransactionalActivityHandler, this.dontExternaliseCache);
    }
}

