/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractStableReadExternalCache;
import com.atlassian.vcache.internal.core.service.UnversionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.google.common.cache.Cache;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaStableReadExternalCache<V>
extends AbstractStableReadExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaStableReadExternalCache.class);
    private final Cache<String, IdentifiedData> delegate;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Optional<Marshaller<V>> valueMarshaller;

    public GuavaStableReadExternalCache(String name, Cache<String, IdentifiedData> delegate, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, Optional<Marshaller<V>> valueMarshaller) {
        super(name);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Nonnull
    public CompletionStage<Boolean> put(String internalKey, V value, PutPolicy policy) {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        return this.perform(() -> {
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            IdentifiedData identifiedData = IdentifiedUtils.marshall((Object)value, this.valueMarshaller);
            return GuavaUtils.directPut(externalKey, identifiedData, policy, this.delegate);
        }, result -> {
            if (result.booleanValue()) {
                cacheContext.recordValue(internalKey, Optional.of(value));
            } else {
                cacheContext.forgetValue(internalKey);
            }
        });
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> internalKeys) {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            for (String key : internalKeys) {
                this.delegate.asMap().remove(cacheContext.externalEntryKeyFor(key));
                cacheContext.forgetValue(key);
            }
            return null;
        });
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            this.delegate.asMap().clear();
            cacheContext.forgetAllValues();
            return null;
        });
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    @Nonnull
    protected AbstractExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = this.contextSupplier.get();
        return (AbstractExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.getName());
            return new UnversionedExternalCacheRequestContext(this.keyGenerator, this.getName(), () -> ((RequestContext)requestContext).partitionIdentifier());
        });
    }

    @Nonnull
    protected V handleCreation(String internalKey, Supplier<V> supplier) throws MarshallerException, ExecutionException, InterruptedException {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        V candidateValue = Objects.requireNonNull(supplier.get());
        IdentifiedData candidateIdentifiedData = IdentifiedUtils.marshall(candidateValue, this.valueMarshaller);
        String externalKey = cacheContext.externalEntryKeyFor(internalKey);
        Optional otherAddedValue = IdentifiedUtils.unmarshall((IdentifiedData)this.delegate.asMap().putIfAbsent(externalKey, candidateIdentifiedData), this.valueMarshaller);
        if (otherAddedValue.isPresent()) {
            this.getLogger().info("Cache {}, unable to add candidate for key {}, use what was added", (Object)this.name, (Object)internalKey);
            cacheContext.recordValue(internalKey, otherAddedValue);
            return (V)otherAddedValue.get();
        }
        cacheContext.recordValue(internalKey, Optional.of(candidateValue));
        return candidateValue;
    }

    @Nonnull
    protected Map<String, V> handleCreation(Function<Set<String>, Map<String, V>> factory, Set<String> externalKeys) throws ExecutionException, InterruptedException {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        Map<String, Optional<V>> candidateValues = this.directGetBulk(externalKeys);
        Set missingExternalKeys = candidateValues.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<String, Object> grandResult = candidateValues.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(e -> cacheContext.internalEntryKeyFor((String)e.getKey()), e -> ((Optional)e.getValue()).get()));
        if (!missingExternalKeys.isEmpty()) {
            this.getLogger().trace("Cache {}: getBulk(Function): calling factory to create {} values", (Object)this.name, (Object)missingExternalKeys.size());
            Set missingInternalKeys = Collections.unmodifiableSet(missingExternalKeys.stream().map(arg_0 -> cacheContext.internalEntryKeyFor(arg_0)).collect(Collectors.toSet()));
            Map<String, V> missingValues = factory.apply(missingInternalKeys);
            if (missingInternalKeys.size() != missingValues.size()) {
                this.getLogger().warn("Cache {}: getBulk(Function): mismatch on generated values, expected ", (Object)this.name, (Object)(missingInternalKeys.size() + " but got " + missingValues.size()));
                throw new ExternalCacheException(ExternalCacheException.Reason.FUNCTION_INCORRECT_RESULT);
            }
            missingValues.entrySet().stream().forEach(e -> this.delegate.put((Object)cacheContext.externalEntryKeyFor((String)e.getKey()), (Object)IdentifiedUtils.marshall(e.getValue(), this.valueMarshaller)));
            grandResult.putAll(missingValues);
        }
        return grandResult;
    }

    @Nonnull
    protected final ExternalCacheException mapException(Exception ex) {
        return GuavaUtils.mapException(ex);
    }

    @Nonnull
    protected final Optional<V> directGet(String externalKey) {
        return IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.getIfPresent((Object)externalKey)), this.valueMarshaller);
    }

    @Nonnull
    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return GuavaUtils.directGetBulk(externalKeys, this.delegate, this.valueMarshaller);
    }
}

