/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExternalCacheRequestContext<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExternalCacheRequestContext.class);
    protected final String name;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Supplier<String> partitionSupplier;
    private final BiMap<String, String> internalToExternalKeyMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final Map<String, String> externalToInternalKeyMap = Collections.unmodifiableMap(this.internalToExternalKeyMap.inverse());
    private final Map<String, Optional<V>> internalKeyToValueMap = new HashMap<String, Optional<V>>();
    private boolean hasRemoveAll;
    private final Map<String, DeferredOperation<V>> keyedOperationMap = new HashMap<String, DeferredOperation<V>>();

    protected AbstractExternalCacheRequestContext(ExternalCacheKeyGenerator keyGenerator, String name, Supplier<String> partitionSupplier) {
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.name = Objects.requireNonNull(name);
        this.partitionSupplier = Objects.requireNonNull(partitionSupplier);
    }

    protected abstract long cacheVersion();

    protected void clearKeyMaps() {
        this.internalToExternalKeyMap.clear();
    }

    @Nonnull
    public String externalEntryKeyFor(String internalKey) {
        String cached = (String)this.internalToExternalKeyMap.get((Object)internalKey);
        if (cached != null) {
            return cached;
        }
        String result = this.keyGenerator.entryKey(this.partitionSupplier.get(), this.name, this.cacheVersion(), internalKey);
        this.internalToExternalKeyMap.forcePut((Object)internalKey, (Object)result);
        return result;
    }

    @Nonnull
    public String internalEntryKeyFor(String externalKey) {
        return Objects.requireNonNull(this.externalToInternalKeyMap.get(externalKey));
    }

    @Nonnull
    public Optional<Optional<V>> getValueRecorded(String internalKey) {
        return Optional.ofNullable(this.internalKeyToValueMap.get(internalKey));
    }

    public void recordValue(String internalKey, Optional<V> outcome) {
        log.trace("Cache {}, recording value for {}", (Object)this.name, (Object)internalKey);
        this.internalKeyToValueMap.put(internalKey, outcome);
    }

    public void recordValues(Map<String, V> knownValues) {
        log.trace("Cache {}, recording {} known values", (Object)this.name, (Object)knownValues.size());
        knownValues.entrySet().stream().collect(() -> this.internalKeyToValueMap, (m, e) -> m.put(e.getKey(), Optional.of(e.getValue())), Map::putAll);
    }

    public void forgetValue(String internalKey) {
        log.trace("Cache {}, forgetting value for {}", (Object)this.name, (Object)internalKey);
        this.internalKeyToValueMap.remove(internalKey);
    }

    public void forgetAllValues() {
        log.trace("Cache {}, forgetting all values", (Object)this.name);
        this.internalKeyToValueMap.clear();
    }

    public void recordPut(String internalKey, V value, PutPolicy policy) {
        this.recordValue(internalKey, Optional.of(value));
        this.keyedOperationMap.put(internalKey, DeferredOperation.putOperation(value, policy));
    }

    public void recordRemove(Iterable<String> internalKeys) {
        for (String internalKey : internalKeys) {
            this.recordValue(internalKey, Optional.empty());
            this.keyedOperationMap.put(internalKey, DeferredOperation.removeOperation());
        }
    }

    public void recordRemoveAll() {
        this.forgetAllValues();
        this.hasRemoveAll = true;
        this.keyedOperationMap.clear();
    }

    public boolean hasRemoveAll() {
        return this.hasRemoveAll;
    }

    public void forgetAll() {
        this.forgetAllValues();
        this.hasRemoveAll = false;
        this.keyedOperationMap.clear();
    }

    public Set<Map.Entry<String, DeferredOperation<V>>> getKeyedOperations() {
        return this.keyedOperationMap.entrySet();
    }

    public boolean hasPendingOperations() {
        return this.hasRemoveAll || !this.keyedOperationMap.isEmpty();
    }

    public static class DeferredOperation<V> {
        private final boolean remove;
        private final Optional<V> value;
        private final Optional<PutPolicy> policy;

        private DeferredOperation() {
            this.remove = true;
            this.value = Optional.empty();
            this.policy = Optional.empty();
        }

        private DeferredOperation(V value, PutPolicy policy) {
            this.remove = false;
            this.value = Optional.of(value);
            this.policy = Optional.of(policy);
        }

        public boolean isRemove() {
            return this.remove;
        }

        public boolean isPut() {
            return !this.remove;
        }

        public V getValue() {
            return this.value.get();
        }

        public PutPolicy getPolicy() {
            return this.policy.get();
        }

        public static <V> DeferredOperation<V> removeOperation() {
            return new DeferredOperation<V>();
        }

        public static <V> DeferredOperation<V> putOperation(V value, PutPolicy policy) {
            return new DeferredOperation<V>(value, policy);
        }
    }
}

