/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.ExternalCache;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.internal.NameValidator;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public abstract class AbstractExternalCache<V>
implements ExternalCache<V> {
    protected final String name;

    protected AbstractExternalCache(String name) {
        this.name = NameValidator.requireValidCacheName((String)name);
    }

    @Nonnull
    protected abstract AbstractExternalCacheRequestContext<V> ensureCacheContext();

    @Nonnull
    protected abstract Logger getLogger();

    @Nonnull
    protected abstract ExternalCacheException mapException(Exception var1);

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nonnull
    protected <T> CompletionStage<T> perform(Callable<T> txn) {
        return this.perform(txn, i -> {});
    }

    @Nonnull
    protected <T> CompletionStage<T> perform(Callable<T> txn, Consumer<T> successHandler) {
        try {
            T outcome = txn.call();
            successHandler.accept(outcome);
            return VCacheCoreUtils.successful(outcome);
        }
        catch (MarshallerException ex) {
            return VCacheCoreUtils.failed(new ExternalCacheException(ExternalCacheException.Reason.MARSHALLER_FAILURE, (Throwable)ex));
        }
        catch (InterruptedException | ExecutionException ex) {
            return VCacheCoreUtils.failed(new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)ex));
        }
        catch (ExternalCacheException ece) {
            return VCacheCoreUtils.failed(ece);
        }
        catch (Exception ex) {
            return VCacheCoreUtils.failed(this.mapException(ex));
        }
    }
}

