/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import java.util.Objects;

class TimedTransactionControl
implements TransactionControl {
    private final TransactionControl delegate;
    private final MetricsCollector metricsCollector;
    private final String cacheName;

    TimedTransactionControl(TransactionControl delegate, MetricsCollector metricsCollector, String cacheName) {
        this.delegate = Objects.requireNonNull(delegate);
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
        this.cacheName = Objects.requireNonNull(cacheName);
    }

    @Override
    public void transactionSync() {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.TIMED_TRANSACTION_SYNC_CALL, t));){
            this.delegate.transactionSync();
        }
    }

    @Override
    public boolean transactionDiscard() {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.TIMED_TRANSACTION_DISCARD_CALL, t));){
            boolean bl = this.delegate.transactionDiscard();
            return bl;
        }
    }
}

