/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import java.util.Objects;
import javax.annotation.Nonnull;

class TimedMarshaller<T>
implements Marshaller<T> {
    private final Marshaller<T> delegate;
    private final MetricsCollector metricsCollector;
    private final String cacheName;

    TimedMarshaller(Marshaller<T> delegate, MetricsCollector metricsCollector, String cacheName) {
        this.delegate = Objects.requireNonNull(delegate);
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
        this.cacheName = Objects.requireNonNull(cacheName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public byte[] marshall(T obj) throws MarshallerException {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.TIMED_MARSHALL_CALL, t));){
            byte[] result = this.delegate.marshall(obj);
            this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.NUMBER_OF_BYTES_MARSHALLED, result.length);
            byte[] byArray = result;
            return byArray;
        }
        catch (MarshallerException me) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.NUMBER_OF_FAILED_MARSHALL, 1L);
            throw me;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public T unmarshall(byte[] raw) throws MarshallerException {
        this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.NUMBER_OF_BYTES_UNMARSHALLED, raw.length);
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.TIMED_UNMARSHALL_CALL, t));){
            Object object = this.delegate.unmarshall(raw);
            return (T)object;
        }
        catch (MarshallerException me) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.cacheName, MetricLabel.NUMBER_OF_FAILED_UNMARSHALL, 1L);
            throw me;
        }
    }
}

