/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.TimedExternalCache;
import com.atlassian.vcache.internal.core.metrics.TimedUtils;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

abstract class TimedExternalWriteOperationsUnbuffered<V>
extends TimedExternalCache<V>
implements ExternalWriteOperationsUnbuffered<V> {
    TimedExternalWriteOperationsUnbuffered(MetricsCollector metricsCollector) {
        super(metricsCollector);
    }

    @Nonnull
    protected abstract ExternalWriteOperationsUnbuffered<V> getDelegateOps();

    @Nonnull
    public CompletionStage<Boolean> put(String key, V value, PutPolicy policy) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_PUT_CALL, t));){
            CompletionStage result = this.getDelegateOps().put(key, value, policy);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_PUT, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> keys) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_REMOVE_CALL, t));){
            CompletionStage result = this.getDelegateOps().remove(keys);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_REMOVE, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_REMOVE_ALL_CALL, t));){
            CompletionStage result = this.getDelegateOps().removeAll();
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_REMOVE_ALL, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }
}

