/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.LongConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VCacheCoreUtils {
    @Nonnull
    public static <T> CompletionStage<T> successful(T value) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        result.complete(value);
        return result;
    }

    @Nonnull
    public static <T> CompletionStage<T> failed(Throwable cause) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(cause);
        return result;
    }

    public static int roundUpToSeconds(Duration time) {
        long result;
        if (time.isNegative()) {
            throw new IllegalArgumentException("duration cannot be negative: " + time);
        }
        long l = result = time.getNano() > 0 ? time.getSeconds() + 1L : time.getSeconds();
        if (result > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("duration exceeds maximum number that can be held in an int");
        }
        return (int)result;
    }

    public static void whenPositive(long number, LongConsumer handler) {
        if (number > 0L) {
            handler.accept(number);
        }
    }

    @Nonnull
    public static <V> byte[] marshall(V data, Marshaller<V> valueMarshaller) throws ExternalCacheException {
        try {
            return valueMarshaller.marshall(data);
        }
        catch (MarshallerException e) {
            throw new ExternalCacheException(ExternalCacheException.Reason.MARSHALLER_FAILURE, (Throwable)e);
        }
    }

    @Nonnull
    public static <V> Optional<V> unmarshall(@Nullable byte[] data, Marshaller<V> valueMarshaller) throws ExternalCacheException {
        if (data == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(valueMarshaller.unmarshall(data));
        }
        catch (MarshallerException ex) {
            throw new ExternalCacheException(ExternalCacheException.Reason.MARSHALLER_FAILURE, (Throwable)ex);
        }
    }

    public static boolean isEmpty(Iterable<String> iter) {
        return !iter.iterator().hasNext();
    }
}

