/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.ContextResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.impl.snapshot.WebModule;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class Context
extends Bundle {
    private final List<WebModule> jsModulesDependencies = new ArrayList<WebModule>();

    public Context(Snapshot snapshot, String key, List<String> dependencies, List<String> moduleDependencies, Date updatedAt, String version, boolean isTransformable) {
        super(snapshot, key, dependencies, updatedAt, version, isTransformable);
        for (String name : moduleDependencies) {
            WebModule module;
            Bundle bundle = this.getSnapshot().get(name);
            if (bundle == null || !(bundle instanceof WebModule) || !"js".equals((module = (WebModule)bundle).getResource().getNameOrLocationType())) continue;
            this.jsModulesDependencies.add(module);
        }
    }

    @Override
    public LinkedHashMap<String, Resource> getResources(RequestCache cache) {
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<String, Resource>();
        if (!this.jsModulesDependencies.isEmpty()) {
            ContextResource resource = new ContextResource(this);
            resources.put(resource.getName(), resource);
        }
        return resources;
    }

    public List<WebModule> getJsModulesDependencies() {
        return this.jsModulesDependencies;
    }
}

