/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.model.WeightedComparator;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemProviderModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionProviderModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebInterfaceManager
implements DynamicWebInterfaceManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebInterfaceManager.class);
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();
    private static final long CACHE_EXPIRY = Long.getLong("com.atlassian.plugin.web.interface.caches.timeout.sec", 3600L);
    private PluginAccessor pluginAccessor;
    private WebFragmentHelper webFragmentHelper;
    private final LoadingCache<String, List<WebSectionModuleDescriptor>> sections = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebSectionCacheLoader());
    private final LoadingCache<String, List<WebItemModuleDescriptor>> items = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebItemCacheLoader());
    private final LoadingCache<String, List<WebPanelModuleDescriptor>> panels = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebPanelCacheLoader());
    private final LoadingCache<String, List<WebItemProviderModuleDescriptor>> itemProviders = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebItemProviderCacheLoader());
    private final LoadingCache<String, List<WebSectionProviderModuleDescriptor>> sectionProviders = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY, TimeUnit.SECONDS).build((CacheLoader)new WebSectionProviderCacheLoader());

    public DefaultWebInterfaceManager() {
        this.refresh();
    }

    public DefaultWebInterfaceManager(PluginAccessor pluginAccessor, WebFragmentHelper webFragmentHelper) {
        this.pluginAccessor = pluginAccessor;
        this.webFragmentHelper = webFragmentHelper;
        this.refresh();
    }

    public boolean hasSectionsForLocation(String location) {
        return !Iterables.isEmpty(this.getWebSections(location, Collections.emptyMap()));
    }

    public List<WebSectionModuleDescriptor> getSections(String location) {
        return location == null ? Collections.emptyList() : (List)this.sections.getUnchecked((Object)location);
    }

    public List<WebSectionModuleDescriptor> getDisplayableSections(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getSections(location), context);
    }

    public List<WebItemModuleDescriptor> getItems(String section) {
        return section == null ? Collections.emptyList() : (List)this.items.getUnchecked((Object)section);
    }

    public List<WebItemModuleDescriptor> getDisplayableItems(String section, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getItems(section), context);
    }

    public List<WebPanel> getDisplayableWebPanels(String location, Map<String, Object> context) {
        return this.toWebPanels(this.getDisplayableWebPanelDescriptors(location, context));
    }

    public List<WebPanelModuleDescriptor> getDisplayableWebPanelDescriptors(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getWebPanelDescriptors(location), context);
    }

    public List<WebPanel> getWebPanels(String location) {
        return this.toWebPanels(this.getWebPanelDescriptors(location));
    }

    private List<WebPanel> toWebPanels(List<WebPanelModuleDescriptor> descriptors) {
        return Lists.transform(descriptors, (Function)new Function<WebPanelModuleDescriptor, WebPanel>(){

            public WebPanel apply(WebPanelModuleDescriptor from) {
                return (WebPanel)from.getModule();
            }
        });
    }

    public List<WebPanelModuleDescriptor> getWebPanelDescriptors(String location) {
        return location == null ? Collections.emptyList() : (List)this.panels.getUnchecked((Object)location);
    }

    private <T extends ConditionalDescriptor> List<T> filterFragmentsByCondition(List<T> relevantItems, Map<String, Object> context) {
        if (relevantItems.isEmpty()) {
            return relevantItems;
        }
        ArrayList<T> result = new ArrayList<T>(relevantItems);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ConditionalDescriptor descriptor = (ConditionalDescriptor)iterator.next();
            try {
                if (descriptor.getCondition() == null || descriptor.getCondition().shouldDisplay(context)) continue;
                iterator.remove();
            }
            catch (Throwable t) {
                log.error("Could not evaluate condition '" + descriptor.getCondition() + "' for descriptor: " + descriptor, t);
                iterator.remove();
            }
        }
        return result;
    }

    public void refresh() {
        this.sections.invalidateAll();
        this.items.invalidateAll();
        this.panels.invalidateAll();
        this.itemProviders.invalidateAll();
        this.sectionProviders.invalidateAll();
    }

    @Deprecated
    public void setPluginManager(PluginManager pluginManager) {
        this.setPluginAccessor((PluginAccessor)pluginManager);
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setWebFragmentHelper(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    public WebFragmentHelper getWebFragmentHelper() {
        return this.webFragmentHelper;
    }

    public Iterable<WebItem> getWebItems(String section, Map<String, Object> context) {
        return this.getDynamicWebItems(this.getItems(section), section, context);
    }

    public Iterable<WebItem> getDisplayableWebItems(String section, Map<String, Object> context) {
        return this.getDynamicWebItems(this.getDisplayableItems(section, context), section, context);
    }

    public Iterable<WebSection> getWebSections(String location, Map<String, Object> context) {
        return this.getDynamicWebSections(this.getSections(location), location, context);
    }

    public Iterable<WebSection> getDisplayableWebSections(String location, Map<String, Object> context) {
        return this.getDynamicWebSections(this.getDisplayableSections(location, context), location, context);
    }

    private Iterable<WebItem> getDynamicWebItems(List<WebItemModuleDescriptor> staticItems, String section, Map<String, Object> context) {
        ArrayList ret = Lists.newArrayList((Iterable)Iterables.transform(staticItems, (Function)new WebItemConverter(context)));
        for (WebItemProviderModuleDescriptor itemProvider : (List)this.itemProviders.getUnchecked((Object)section)) {
            try {
                Option providedItems = Option.option((Object)itemProvider.getModule().getItems(context));
                if (!providedItems.isDefined()) continue;
                Iterables.addAll((Collection)ret, (Iterable)((Iterable)providedItems.get()));
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.error("WebItemProvider from module '" + itemProvider.getCompleteKey() + "' threw an error '" + e.getMessage() + "'.  Web-items provided by this provider will be ignored.", (Throwable)e);
                    continue;
                }
                log.error("WebItemProvider from module '" + itemProvider.getCompleteKey() + "' threw an error '" + e.getMessage() + "'.  Web-items provided by this provider will be ignored.");
            }
        }
        Collections.sort(ret, WeightedComparator.WEIGHTED_FRAGMENT_COMPARATOR);
        return ret;
    }

    private Iterable<WebSection> getDynamicWebSections(List<WebSectionModuleDescriptor> staticSections, String location, Map<String, Object> context) {
        ArrayList ret = Lists.newArrayList((Iterable)Iterables.transform(staticSections, (Function)new WebSectionConverter(context)));
        for (WebSectionProviderModuleDescriptor provider : (List)this.sectionProviders.getUnchecked((Object)location)) {
            try {
                Option sections = Option.option((Object)provider.getModule().getSections(context));
                if (!sections.isDefined()) continue;
                Iterables.addAll((Collection)ret, (Iterable)((Iterable)sections.get()));
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.error("WebSectionProvider from module '" + provider.getCompleteKey() + "' threw an error '" + e.getMessage() + "'.  Web-sections provided by this provider will be ignored.", (Throwable)e);
                    continue;
                }
                log.error("WebItemProvider from module '" + provider.getCompleteKey() + "' threw an error '" + e.getMessage() + "'.  Web-sections provided by this provider will be ignored.");
            }
        }
        Collections.sort(ret, WeightedComparator.WEIGHTED_FRAGMENT_COMPARATOR);
        return ret;
    }

    private class WebSectionProviderCacheLoader
    extends CacheLoader<String, List<WebSectionProviderModuleDescriptor>> {
        private WebSectionProviderCacheLoader() {
        }

        public List<WebSectionProviderModuleDescriptor> load(final String location) throws Exception {
            List providers = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebSectionProviderModuleDescriptor.class);
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)providers, (Predicate)new Predicate<WebSectionProviderModuleDescriptor>(){

                public boolean apply(WebSectionProviderModuleDescriptor input) {
                    return StringUtils.equals((String)input.getLocation(), (String)location);
                }
            }));
        }
    }

    private class WebItemProviderCacheLoader
    extends CacheLoader<String, List<WebItemProviderModuleDescriptor>> {
        private WebItemProviderCacheLoader() {
        }

        public List<WebItemProviderModuleDescriptor> load(final String section) throws Exception {
            List providers = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebItemProviderModuleDescriptor.class);
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)providers, (Predicate)new Predicate<WebItemProviderModuleDescriptor>(){

                public boolean apply(WebItemProviderModuleDescriptor input) {
                    return StringUtils.equals((String)input.getSection(), (String)section);
                }
            }));
        }
    }

    private class WebPanelCacheLoader
    extends CacheLoader<String, List<WebPanelModuleDescriptor>> {
        private WebPanelCacheLoader() {
        }

        public List<WebPanelModuleDescriptor> load(final String location) throws Exception {
            List descriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebPanelModuleDescriptor.class);
            ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)new Predicate<WebPanelModuleDescriptor>(){

                public boolean apply(WebPanelModuleDescriptor input) {
                    return StringUtils.equals((String)location, (String)input.getLocation());
                }
            }));
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            return result;
        }
    }

    private class WebItemCacheLoader
    extends CacheLoader<String, List<WebItemModuleDescriptor>> {
        private WebItemCacheLoader() {
        }

        public List<WebItemModuleDescriptor> load(final String section) throws Exception {
            List descriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebItemModuleDescriptor.class);
            ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)new Predicate<WebItemModuleDescriptor>(){

                public boolean apply(WebItemModuleDescriptor input) {
                    return StringUtils.equals((String)section, (String)input.getSection());
                }
            }));
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            return result;
        }
    }

    private class WebSectionCacheLoader
    extends CacheLoader<String, List<WebSectionModuleDescriptor>> {
        private WebSectionCacheLoader() {
        }

        public List<WebSectionModuleDescriptor> load(final String location) throws Exception {
            List descriptors = DefaultWebInterfaceManager.this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebSectionModuleDescriptor.class);
            ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)new Predicate<WebSectionModuleDescriptor>(){

                public boolean apply(WebSectionModuleDescriptor input) {
                    return StringUtils.equals((String)location, (String)input.getLocation());
                }
            }));
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            return result;
        }
    }

    private static class WebSectionConverter
    implements Function<WebSectionModuleDescriptor, WebSection> {
        private final Map<String, Object> context;

        public WebSectionConverter(Map<String, Object> context) {
            this.context = context;
        }

        public WebSection apply(WebSectionModuleDescriptor input) {
            WebFragmentBuilder builder = new WebFragmentBuilder(input.getCompleteKey(), input.getWeight());
            builder.id(input.getKey());
            if (input.getWebLabel() != null) {
                builder.label(input.getWebLabel().getDisplayableLabel(null, this.context));
            }
            if (input.getTooltip() != null) {
                builder.title(input.getTooltip().getDisplayableLabel(null, this.context));
            }
            if (input.getWebParams() != null) {
                builder.params((Map)input.getWebParams().getParams());
            }
            return builder.webSection(input.getLocation()).build();
        }
    }

    private static class WebItemConverter
    implements Function<WebItemModuleDescriptor, WebItem> {
        private final Map<String, Object> context;

        public WebItemConverter(Map<String, Object> context) {
            this.context = context;
        }

        public WebItem apply(WebItemModuleDescriptor input) {
            WebFragmentBuilder builder = new WebFragmentBuilder(input.getCompleteKey(), input.getWeight());
            builder.styleClass(input.getStyleClass());
            if (input.getWebLabel() != null) {
                builder.label(input.getWebLabel().getDisplayableLabel(null, this.context));
            }
            if (input.getTooltip() != null) {
                builder.title(input.getTooltip().getDisplayableLabel(null, this.context));
            }
            if (input.getWebParams() != null) {
                builder.params((Map)input.getWebParams().getParams());
            }
            if (input.getIcon() != null && input.getIcon().getUrl() != null) {
                builder.addParam("iconUrl", input.getIcon().getUrl().getRenderedUrl(this.context));
            }
            WebFragmentBuilder.WebItemBuilder webItemBuilder = builder.webItem(input.getSection());
            WebLink link = input.getLink();
            if (link != null) {
                Option httpRequest;
                builder.id(link.getId());
                if (link.hasAccessKey()) {
                    webItemBuilder.accessKey(link.getAccessKey(this.context));
                }
                String url = (httpRequest = Option.option((Object)((HttpServletRequest)this.context.get("request")))).isDefined() ? link.getDisplayableUrl((HttpServletRequest)httpRequest.get(), this.context) : link.getRenderedUrl(this.context);
                webItemBuilder.url(url);
            }
            return webItemBuilder.build();
        }
    }
}

