/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import aQute.bnd.osgi.AbstractResource;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class ClassBinaryScanner {
    public static ScanResult scanClassBinary(Clazz clazz) throws IOException {
        final ImmutableSet.Builder allReferredClasses = new ImmutableSet.Builder();
        final String[] superClassName = new String[]{null};
        try {
            clazz.parseClassFileWithCollector(new ClassDataCollector(){

                public void extendsClass(Descriptors.TypeRef ref) {
                    superClassName[0] = ref.getBinary();
                    allReferredClasses.add((Object)ref.getBinary());
                }

                public void implementsInterfaces(Descriptors.TypeRef[] refs) {
                    for (Descriptors.TypeRef ref : refs) {
                        allReferredClasses.add((Object)ref.getBinary());
                    }
                }

                public void addReference(Descriptors.TypeRef ref) {
                    allReferredClasses.add((Object)ref.getBinary());
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Error parsing class file", e);
        }
        HashSet referredPackages = Sets.newHashSet((Iterable)Collections2.transform((Collection)clazz.getReferred(), (Function)new Function<Descriptors.PackageRef, String>(){

            public String apply(@Nullable Descriptors.PackageRef packageRef) {
                if (packageRef != null) {
                    return packageRef.getFQN();
                }
                return null;
            }
        }));
        return new ScanResult((Set<String>)allReferredClasses.build(), referredPackages, superClassName[0]);
    }

    public static class InputStreamResource
    extends AbstractResource {
        private InputStream inputStream;

        public InputStreamResource(InputStream inputStream) {
            super(-1L);
            this.inputStream = inputStream;
        }

        protected byte[] getBytes() throws Exception {
            return IOUtils.toByteArray((InputStream)this.inputStream);
        }

        public void close() {
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
    }

    public static class ScanResult {
        private Set<String> referredClasses;
        private Set<String> referredPackages;
        private String superClass;

        public ScanResult(Set<String> referredClasses, Set<String> referredPackages, String superClass) {
            this.referredClasses = referredClasses;
            this.referredPackages = referredPackages;
            this.superClass = superClass;
        }

        public Set<String> getReferredClasses() {
            return this.referredClasses;
        }

        public Set<String> getReferredPackages() {
            return this.referredPackages;
        }

        public String getSuperClass() {
            return this.superClass;
        }
    }
}

