/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.fugue.Effect;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import java.util.Map;

public class PluginPersistentStateModifier {
    private final PluginPersistentStateStore store;

    public PluginPersistentStateModifier(PluginPersistentStateStore store) {
        this.store = store;
    }

    public PluginPersistentState getState() {
        return this.store.load();
    }

    @Deprecated
    PluginPersistentStateStore getStore() {
        return this.store;
    }

    public synchronized void apply(Effect<PluginPersistentState.Builder> effect) {
        PluginPersistentState.Builder builder = PluginPersistentState.Builder.create(this.store.load());
        effect.apply((Object)builder);
        this.store.save(builder.toState());
    }

    public void setEnabled(final Plugin plugin, final boolean enabled) {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.setEnabled(plugin, enabled);
            }
        });
    }

    public void disable(Plugin plugin) {
        this.setEnabled(plugin, false);
    }

    public void enable(Plugin plugin) {
        this.setEnabled(plugin, true);
    }

    public void setEnabled(final ModuleDescriptor<?> module, final boolean enabled) {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.setEnabled(module, enabled);
            }
        });
    }

    public void disable(ModuleDescriptor<?> module) {
        this.setEnabled(module, false);
    }

    public void enable(ModuleDescriptor<?> module) {
        this.setEnabled(module, true);
    }

    public void clearPluginRestartState() {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.clearPluginRestartState();
            }
        });
    }

    public void setPluginRestartState(final String pluginKey, final PluginRestartState pluginRestartState) {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.setPluginRestartState(pluginKey, pluginRestartState);
            }
        });
    }

    public void addState(final Map<String, Boolean> state) {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.addState(state);
            }
        });
    }

    public void removeState(final Plugin plugin) {
        this.apply(new Effect<PluginPersistentState.Builder>(){

            public void apply(PluginPersistentState.Builder builder) {
                builder.removeState(plugin.getKey());
                for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
                    builder.removeState(moduleDescriptor.getCompleteKey());
                }
            }
        });
    }
}

