/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.DefaultPluginPersistentState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public interface PluginPersistentState {
    public Map<String, Boolean> getMap();

    public boolean isEnabled(Plugin var1);

    public boolean isEnabled(ModuleDescriptor<?> var1);

    public Map<String, Boolean> getPluginStateMap(Plugin var1);

    public PluginRestartState getPluginRestartState(String var1);

    public static class Util {
        public static final String RESTART_STATE_SEPARATOR = "--";

        static String buildStateKey(String pluginKey, PluginRestartState state) {
            StringBuilder sb = new StringBuilder();
            sb.append(state.name());
            sb.append(RESTART_STATE_SEPARATOR);
            sb.append(pluginKey);
            return sb.toString();
        }
    }

    public static final class Builder {
        private final Map<String, Boolean> map = new HashMap<String, Boolean>();

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(PluginPersistentState state) {
            return new Builder(state);
        }

        Builder() {
        }

        Builder(PluginPersistentState state) {
            this.map.putAll(state.getMap());
        }

        public PluginPersistentState toState() {
            return new DefaultPluginPersistentState(this.map, true);
        }

        public Builder setEnabled(ModuleDescriptor<?> pluginModule, boolean isEnabled) {
            this.setEnabled(pluginModule.getCompleteKey(), pluginModule.isEnabledByDefault(), isEnabled);
            return this;
        }

        public Builder setEnabled(Plugin plugin, boolean isEnabled) {
            this.setEnabled(plugin.getKey(), plugin.isEnabledByDefault(), isEnabled);
            return this;
        }

        private Builder setEnabled(String completeKey, boolean enabledByDefault, boolean isEnabled) {
            if (isEnabled == enabledByDefault) {
                this.map.remove(completeKey);
            } else {
                this.map.put(completeKey, isEnabled);
            }
            return this;
        }

        public Builder setState(PluginPersistentState state) {
            this.map.clear();
            this.map.putAll(state.getMap());
            return this;
        }

        public Builder addState(Map<String, Boolean> state) {
            this.map.putAll(state);
            return this;
        }

        public Builder removeState(String key) {
            this.map.remove(key);
            return this;
        }

        public Builder setPluginRestartState(String pluginKey, PluginRestartState state) {
            for (PluginRestartState st : PluginRestartState.values()) {
                this.map.remove(Util.buildStateKey(pluginKey, st));
            }
            if (state != PluginRestartState.NONE) {
                this.map.put(Util.buildStateKey(pluginKey, state), true);
            }
            return this;
        }

        public Builder clearPluginRestartState() {
            HashSet<String> keys = new HashSet<String>(this.map.keySet());
            for (String key : keys) {
                if (!key.contains("--")) continue;
                this.map.remove(key);
            }
            return this;
        }
    }
}

