/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.manager.ApplicationDefinedPluginsProvider;
import com.atlassian.plugin.manager.ClusterEnvironmentProvider;
import com.atlassian.plugin.manager.SafeModeManager;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.parsers.SafeModeCommandLineArguments;
import com.atlassian.plugin.parsers.SafeModeCommandLineArgumentsFactory;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class DefaultSafeModeManager
implements SafeModeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSafeModeManager.class);
    private final SafeModeCommandLineArguments parser;
    private final PluginMetadataManager pluginMetadataManager;
    private final ApplicationDefinedPluginsProvider appRelatedPluginsProvider;
    private final ClusterEnvironmentProvider clusterEnvironmentProvider;

    public DefaultSafeModeManager(PluginMetadataManager pluginMetadataManager, ClusterEnvironmentProvider clusterEnvironmentProvider, SafeModeCommandLineArgumentsFactory safeModeCommandLineArgumentsFactory) {
        this(pluginMetadataManager, ApplicationDefinedPluginsProvider.NO_APPLICATION_PLUGINS, clusterEnvironmentProvider, safeModeCommandLineArgumentsFactory);
    }

    DefaultSafeModeManager(PluginMetadataManager pluginMetadataManager, ApplicationDefinedPluginsProvider appRelatedPluginsProvider, ClusterEnvironmentProvider clusterEnvironmentProvider, SafeModeCommandLineArgumentsFactory safeModeCommandLineArgumentsFactory) {
        this.pluginMetadataManager = pluginMetadataManager;
        this.parser = safeModeCommandLineArgumentsFactory.get();
        this.appRelatedPluginsProvider = appRelatedPluginsProvider;
        this.clusterEnvironmentProvider = clusterEnvironmentProvider;
        if (clusterEnvironmentProvider.isInCluster() && (this.parser.isSafeMode() || !this.parser.getDisabledPlugins().orElse(Collections.emptyList()).isEmpty())) {
            LOGGER.warn("Add-ons disable options from '{}' are being ignored due to start up in clustered mode!", (Object)this.parser.getSafeModeArguments());
        }
    }

    @Override
    public boolean pluginShouldBeStarted(Plugin plugin, Iterable<ModuleDescriptor> descriptors) {
        return this.clusterEnvironmentProvider.isInCluster() || (!this.parser.isSafeMode() || this.isSystemPlugin(plugin, descriptors)) && !this.parser.isDisabledByParam(plugin.getKey());
    }

    private boolean isSystemPlugin(Plugin plugin, Iterable<ModuleDescriptor> descriptors) {
        return this.pluginMetadataManager.isSystemProvided(plugin) || !this.pluginMetadataManager.isOptional(plugin) || this.appRelatedPluginsProvider.getPluginKeys(descriptors).contains(plugin.getKey());
    }
}

