/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

public final class ModuleDescriptors {

    @NotThreadSafe
    public static class HashCodeBuilder {
        private ModuleDescriptor descriptor;

        public HashCodeBuilder descriptor(ModuleDescriptor descriptor) {
            Preconditions.checkNotNull((Object)descriptor, (Object)"Tried to calculate the hash code of a null module descriptor.");
            this.descriptor = descriptor;
            return this;
        }

        public int toHashCode() {
            Preconditions.checkNotNull((Object)this.descriptor, (Object)"Tried to calculate the hash code of a null module descriptor.");
            return this.descriptor.getCompleteKey() == null ? 0 : this.descriptor.getCompleteKey().hashCode();
        }

        public int hashCode() {
            return this.toHashCode();
        }
    }

    @NotThreadSafe
    public static class EqualsBuilder {
        private ModuleDescriptor descriptor;

        public EqualsBuilder descriptor(ModuleDescriptor descriptor) {
            Preconditions.checkNotNull((Object)descriptor, (Object)"Tried to build an equals implementation for a null module descriptor. This is not allowed.");
            this.descriptor = descriptor;
            return this;
        }

        public boolean isEqualTo(Object obj) {
            Preconditions.checkNotNull((Object)this.descriptor, (Object)"Tried to build an equals implementation for a null module descriptor. This is not allowed.");
            if (this.descriptor == obj) {
                return true;
            }
            if (!(obj instanceof ModuleDescriptor)) {
                return false;
            }
            ModuleDescriptor rhs = (ModuleDescriptor)obj;
            return new org.apache.commons.lang.builder.EqualsBuilder().append((Object)this.descriptor.getCompleteKey(), (Object)rhs.getCompleteKey()).isEquals();
        }
    }
}

