/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.appender;

import com.atlassian.logging.log4j.appender.fluentd.FluentdHttpSender;
import com.atlassian.logging.log4j.appender.fluentd.FluentdLogQueueSendTask;
import com.atlassian.logging.log4j.appender.fluentd.FluentdSender;
import com.atlassian.logging.log4j.appender.fluentd.FluentdStdOutSender;
import com.atlassian.logging.log4j.appender.fluentd.LoggingEventQueue;
import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class FluentdAppender
extends AppenderSkeleton {
    private static final int DEFAULT_BATCH_PERIOD_MS = 1000;
    public static final int DEFAULT_MAX_NUM_LOG_EVENTS = 2000;
    private static final int DEFAULT_MAX_RETRY_PERIOD_MS = 14400000;
    private static final int DEFAULT_BACKOFF_MULTIPLIER = 10;
    private static final int DEFAULT_MAX_BACKOFF_MINUTES = 10;
    private static final String SYS_PROP_ENABLE_KEY = "atlassian.logging.cloud.enabled";
    private static final String SYS_PROP_STD_OUT_MODE = "atlassian.logging.cloud.stdOutMode";
    private long batchPeriodMs = 1000L;
    private long maxNumLogEvents = 2000L;
    private int maxRetryPeriodMs = 14400000;
    private int backoffMultiplier = 10;
    private int maxBackoffMinutes = 10;
    private String fluentdEndpoint;
    private LoggingEventQueue loggingEventQueue;
    private FluentdLogQueueSendTask sendTask;
    private final boolean isEnabled = Boolean.getBoolean("atlassian.logging.cloud.enabled");

    public FluentdAppender() {
    }

    protected FluentdAppender(boolean isActive) {
        this();
    }

    public void activateOptions() {
        if (!this.isEnabled) {
            return;
        }
        Preconditions.checkNotNull((Object)this.fluentdEndpoint);
        this.loggingEventQueue = new LoggingEventQueue(this.maxNumLogEvents);
        FluentdSender fluentdSender = Boolean.getBoolean(SYS_PROP_STD_OUT_MODE) ? new FluentdStdOutSender() : new FluentdHttpSender(this.fluentdEndpoint);
        this.sendTask = new FluentdLogQueueSendTask(this.getLayout(), this.loggingEventQueue, fluentdSender, this.maxRetryPeriodMs, this.backoffMultiplier, this.maxBackoffMinutes);
        new Timer().schedule((TimerTask)this.sendTask, 0L, this.batchPeriodMs);
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.isEnabled) {
            loggingEvent.getThreadName();
            loggingEvent.getMDCCopy();
            loggingEvent.getLocationInformation();
            this.loggingEventQueue.enqueue(loggingEvent);
        }
    }

    public void close() {
        if (!this.isEnabled) {
            return;
        }
        this.sendTask.cancel();
        this.sendTask.clean();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setFluentdEndpoint(String fluentdEndpoint) {
        this.fluentdEndpoint = fluentdEndpoint;
    }

    public void setBatchPeriodMs(long batchPeriodMs) {
        this.batchPeriodMs = batchPeriodMs;
    }

    public void setMaxNumEvents(long maxNumLogEvents) {
        this.maxNumLogEvents = maxNumLogEvents;
    }

    public void setMaxRetryPeriodMs(int maxRetryPeriodMs) {
        this.maxRetryPeriodMs = maxRetryPeriodMs;
    }

    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public void setMaxBackoffMinutes(int maxBackoffMinutes) {
        this.maxBackoffMinutes = maxBackoffMinutes;
    }
}

