/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.Johnson;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;

public class EventLevel {
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    public static final String WARNING = "warning";
    private final String description;
    private final String level;

    public EventLevel(String level, String description) {
        this.description = description;
        this.level = level;
    }

    @Nullable
    public static EventLevel get(@Nonnull String level) {
        return Johnson.getConfig().getEventLevel(level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventLevel)) {
            return false;
        }
        EventLevel e = (EventLevel)o;
        return ObjectUtils.equals((Object)this.getDescription(), (Object)e.getDescription()) && ObjectUtils.equals((Object)this.getLevel(), (Object)e.getLevel());
    }

    public String getDescription() {
        return this.description;
    }

    public String getLevel() {
        return this.level;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + ObjectUtils.hashCode((Object)this.getLevel());
        result = 31 * result + ObjectUtils.hashCode((Object)this.getDescription());
        return result;
    }

    public String toString() {
        return "(EventLevel: " + this.level + ")";
    }
}

