/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter;

import com.atlassian.gzipfilter.util.FlushableGZIPOutputStreamFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class GzipResponseStream
extends ServletOutputStream {
    protected final GZIPOutputStream gzipstream;
    protected final HttpServletResponse response;
    private static final int DEFAULT_BUFFER_SIZE_BYTES = 1024;

    public GzipResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.gzipstream = FlushableGZIPOutputStreamFactory.makeFlushableGZIPOutputStream((OutputStream)response.getOutputStream(), 1024);
    }

    public void close() throws IOException {
        this.gzipstream.close();
    }

    public void flush() throws IOException {
        this.gzipstream.flush();
    }

    public void write(int b) throws IOException {
        this.gzipstream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.gzipstream.write(b, off, len);
    }
}

