/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extension.plugins;

import com.atlassian.extension.api.ExtensionAccessor;
import com.atlassian.extension.util.Streams;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExtensionAccessingPluginAccessor
implements PluginAccessor {
    private final ExtensionAccessor extensionAccessor;
    private final PluginAccessor pluginAccessor;
    private final ModuleDescriptorFactory moduleDescriptorFactory;

    public ExtensionAccessingPluginAccessor(ExtensionAccessor extensionAccessor, PluginAccessor pluginAccessor, ModuleDescriptorFactory moduleDescriptorFactory) {
        this.extensionAccessor = extensionAccessor;
        this.pluginAccessor = pluginAccessor;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
    }

    public <M> List<M> getEnabledModulesByClass(Class<M> moduleClass) {
        return ImmutableList.copyOf((Iterable)this.extensionAccessor.getExtensionsByClass(moduleClass));
    }

    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>> moduleDescriptorClass, Class<M> moduleClass) {
        Iterable extensions = this.extensionAccessor.getExtensionsByClass(moduleDescriptorClass);
        return Streams.stream((Iterable)extensions).filter(moduleDescriptor -> moduleClass.isAssignableFrom(moduleDescriptor.getModuleClass())).map(ModuleDescriptor::getModule).collect(Collectors.toList());
    }

    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>>[] descriptorClasses, Class<M> moduleClass) {
        List descriptorClassList = Arrays.asList(descriptorClasses);
        return ImmutableList.copyOf(this.getModules(moduleDescriptor -> moduleClass.isAssignableFrom(moduleDescriptor.getModuleClass()) && Iterables.any((Iterable)descriptorClassList, descriptorClass -> descriptorClass.isInstance(moduleDescriptor))));
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClass) {
        return ImmutableList.copyOf((Iterable)this.extensionAccessor.getExtensionsByClass(descriptorClass));
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClass, boolean verbose) {
        return this.getEnabledModuleDescriptorsByClass(descriptorClass);
    }

    @Deprecated
    public <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByType(String type) throws PluginParseException {
        Class moduleDescriptorClass;
        Class moduleDescriptorClassPrecise = moduleDescriptorClass = this.moduleDescriptorFactory.getModuleDescriptorClass(type);
        return ImmutableList.copyOf((Iterable)this.extensionAccessor.getExtensionsByClass(moduleDescriptorClassPrecise));
    }

    public <M> Collection<M> getModules(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        return this.getModuleDescriptors(moduleDescriptorPredicate).stream().map(ModuleDescriptor::getModule).collect(Collectors.toList());
    }

    public <M> Collection<ModuleDescriptor<M>> getModuleDescriptors(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        Iterable moduleDescriptors = this.extensionAccessor.getExtensionsByClass(ModuleDescriptor.class);
        Stream<Object> matchingModuleDescriptors = Streams.stream((Iterable)moduleDescriptors).filter(arg_0 -> moduleDescriptorPredicate.matches(arg_0)).map(moduleDescriptor -> (ModuleDescriptor)moduleDescriptor);
        return matchingModuleDescriptors.collect(Collectors.toList());
    }

    public Collection<Plugin> getPlugins() {
        return this.pluginAccessor.getPlugins();
    }

    public Collection<Plugin> getPlugins(PluginPredicate pluginPredicate) {
        return this.pluginAccessor.getPlugins(pluginPredicate);
    }

    public Collection<Plugin> getEnabledPlugins() {
        return this.pluginAccessor.getEnabledPlugins();
    }

    public Plugin getPlugin(String key) throws IllegalArgumentException {
        return this.pluginAccessor.getPlugin(key);
    }

    public Plugin getEnabledPlugin(String pluginKey) throws IllegalArgumentException {
        return this.pluginAccessor.getEnabledPlugin(pluginKey);
    }

    public ModuleDescriptor<?> getPluginModule(String completeKey) {
        return this.pluginAccessor.getPluginModule(completeKey);
    }

    public ModuleDescriptor<?> getEnabledPluginModule(String completeKey) {
        return this.pluginAccessor.getEnabledPluginModule(completeKey);
    }

    public boolean isPluginEnabled(String key) throws IllegalArgumentException {
        return this.pluginAccessor.isPluginEnabled(key);
    }

    public boolean isPluginModuleEnabled(String completeKey) {
        return this.pluginAccessor.isPluginModuleEnabled(completeKey);
    }

    public InputStream getDynamicResourceAsStream(String resourcePath) {
        return this.pluginAccessor.getDynamicResourceAsStream(resourcePath);
    }

    @Deprecated
    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        return this.pluginAccessor.getPluginResourceAsStream(pluginKey, resourcePath);
    }

    @Deprecated
    public Class<?> getDynamicPluginClass(String className) throws ClassNotFoundException {
        return this.pluginAccessor.getDynamicPluginClass(className);
    }

    public ClassLoader getClassLoader() {
        return this.pluginAccessor.getClassLoader();
    }

    public boolean isSystemPlugin(String key) {
        return this.pluginAccessor.isSystemPlugin(key);
    }

    public PluginRestartState getPluginRestartState(String key) {
        return this.pluginAccessor.getPluginRestartState(key);
    }

    public Iterable<ModuleDescriptor<?>> getDynamicModules(Plugin plugin) {
        return this.pluginAccessor.getDynamicModules(plugin);
    }
}

