/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.FifoBuffer;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.sql.Timestamp;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskQueue
implements TaskQueue {
    private static final transient Logger log = LoggerFactory.getLogger(AbstractTaskQueue.class);
    protected FifoBuffer<Task> buffer;
    private boolean flushing;
    private Timestamp flushStarted;

    public AbstractTaskQueue(FifoBuffer<Task> buffer) {
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        this.flushStarted = new Timestamp(System.currentTimeMillis());
        try {
            Task task;
            while ((task = this.buffer.remove()) != null) {
                log.debug("Executing: " + task);
                try {
                    task.execute();
                }
                catch (Exception e) {
                    this.handleException(task, e);
                }
            }
        }
        finally {
            this.flushing = false;
            this.flushStarted = null;
        }
    }

    protected void handleException(Task task, Exception e) {
        log.error("Failed to execute task : " + task, (Throwable)e);
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public void addTask(Task task) {
        log.debug("Queued: " + task);
        this.buffer.add(task);
    }

    public Collection<Task> getQueue() {
        return this.buffer.getItems();
    }

    @Override
    public boolean isFlushing() {
        return this.flushing;
    }

    @Override
    public Timestamp getFlushStarted() {
        return this.flushStarted;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public Collection<Task> getTasks() {
        return this.buffer.getItems();
    }
}

