/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.xml;

import com.atlassian.config.AbstractConfigurationPersister;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.xml.Dom4jXmlListConfigElement;
import com.atlassian.config.xml.Dom4jXmlMapConfigElement;
import com.atlassian.config.xml.Dom4jXmlMapEntryConfigElement;
import com.atlassian.config.xml.Dom4jXmlStringConfigElement;
import com.atlassian.core.util.Dom4jUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractDom4jXmlConfigurationPersister
extends AbstractConfigurationPersister {
    public static final Logger log = Logger.getLogger(AbstractDom4jXmlConfigurationPersister.class);
    private Document document;
    protected boolean useCData = false;

    public AbstractDom4jXmlConfigurationPersister() {
        this.clearDocument();
        this.addConfigMapping(String.class, Dom4jXmlStringConfigElement.class);
        this.addConfigMapping(Map.class, Dom4jXmlMapConfigElement.class);
        this.addConfigMapping(Map.Entry.class, Dom4jXmlMapEntryConfigElement.class);
        this.addConfigMapping(List.class, Dom4jXmlListConfigElement.class);
    }

    public Document loadDocument(File xmlFile) throws DocumentException, MalformedURLException {
        SAXReader xmlReader = new SAXReader();
        this.document = xmlReader.read(xmlFile);
        return this.document;
    }

    public Object load(InputStream istream) throws ConfigurationException {
        try {
            return this.loadDocument(istream);
        }
        catch (DocumentException e) {
            throw new ConfigurationException("Failed to load Xml doc: " + e.getMessage(), e);
        }
    }

    public Document loadDocument(InputStream istream) throws DocumentException {
        SAXReader xmlReader = new SAXReader();
        this.document = xmlReader.read(istream);
        return this.document;
    }

    public void save(String configPath, String configFile) throws ConfigurationException {
        this.saveDocument(configPath, configFile);
    }

    public void saveDocument(String configPath, String configFile) throws ConfigurationException {
        try {
            this.saveDocumentAtomically(this.getDocument(), configPath, configFile);
        }
        catch (IOException e) {
            throw new ConfigurationException("Couldn't save " + configFile + " to " + configPath + " directory.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentAtomically(Document document, String configPath, String configFile) throws IOException {
        File tempFile = File.createTempFile(configFile, "tmp", new File(configPath));
        File saveFile = new File(configPath, configFile);
        try {
            Dom4jUtil.saveDocumentTo((Document)document, (String)configPath, (String)tempFile.getName());
            if (!tempFile.renameTo(saveFile)) {
                log.warn((Object)("Unable to move " + tempFile.getCanonicalPath() + " to " + saveFile.getCanonicalPath() + ". Falling back to non-atomic overwrite."));
                Dom4jUtil.saveDocumentTo((Document)document, (String)configPath, (String)configFile);
            }
        }
        finally {
            tempFile.delete();
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Object getRootContext() {
        return this.document.getRootElement();
    }

    public Element getElement(String path) {
        return DocumentHelper.makeElement((Branch)this.document, (String)path);
    }

    public void clear() {
        this.clearDocument();
    }

    private void clearDocument() {
        this.document = null;
        this.document = DocumentHelper.createDocument();
        this.document.addElement(this.getRootName());
    }

    public abstract String getRootName();

    public boolean isUseCData() {
        return this.useCData;
    }

    public void setUseCData(boolean useCData) {
        this.useCData = useCData;
    }
}

