/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.bootstrap;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.HomeLocator;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.config.db.HibernateConfigurator;
import com.atlassian.config.setup.SetupPersister;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultAtlassianBootstrapManager
implements AtlassianBootstrapManager {
    public static final Logger log = Logger.getLogger(DefaultAtlassianBootstrapManager.class);
    protected boolean bootstrapped;
    protected String bootstrapFailureReason;
    private String operation;
    private List tables;
    protected ApplicationConfiguration applicationConfig;
    protected SetupPersister setupPersister;
    protected HomeLocator homeLocator;
    protected HibernateConfigurator hibernateConfigurator;
    protected HibernateConfig hibernateConfig;

    public void init() throws BootstrapException {
        try {
            if (StringUtils.isNotEmpty((String)this.homeLocator.getHomePath())) {
                this.applicationConfig.setApplicationHome(this.homeLocator.getHomePath());
                this.applicationConfig.setConfigurationFileName(this.homeLocator.getConfigFileName());
                if (this.applicationConfig.configFileExists()) {
                    this.applicationConfig.load();
                }
                this.afterConfigurationLoaded();
                this.setupPersister.setSetupType(this.applicationConfig.getSetupType());
                if ("complete".equals(this.setupPersister.getCurrentStep())) {
                    if (!this.performPersistenceUpgrade()) {
                        return;
                    }
                    this.applicationConfig.setSetupComplete(true);
                    this.publishConfiguration();
                }
            } else {
                log.warn((Object)"Unable to set up application config: no home set");
            }
            this.finishBootstrapInitialisation();
            this.bootstrapped = true;
        }
        catch (ConfigurationException e) {
            log.error((Object)("Home is not configured properly: " + e));
            this.bootstrapped = false;
            this.bootstrapFailureReason = e.getMessage();
        }
    }

    public void publishConfiguration() {
    }

    public Object getProperty(String key) {
        Object o = null;
        try {
            o = this.applicationConfig.getProperty(key);
        }
        catch (NullPointerException e) {
            log.error((Object)("BootstrapManager was asked to fetch property (" + key + ") and found a NullPointer"));
        }
        return o;
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.applicationConfig.removeProperty(key);
        } else {
            this.applicationConfig.setProperty((Object)key, value);
        }
        if (this.isSetupComplete()) {
            this.publishConfiguration();
        }
    }

    public boolean isPropertyTrue(String prop) {
        return "true".equals(this.getString(prop));
    }

    public void removeProperty(String key) {
        this.applicationConfig.removeProperty(key);
    }

    public String getString(String key) {
        return (String)this.applicationConfig.getProperty(key);
    }

    public String getFilePathProperty(String key) {
        return this.getString(key);
    }

    public Collection getPropertyKeys() {
        return this.applicationConfig.getProperties().keySet();
    }

    public Map getPropertiesWithPrefix(String prefix) {
        return this.applicationConfig.getPropertiesWithPrefix(prefix);
    }

    public void save() throws ConfigurationException {
        this.applicationConfig.save();
    }

    public String getConfiguredApplicationHome() {
        return this.homeLocator.getHomePath();
    }

    public boolean isSetupComplete() {
        return this.isBootstrapped() && this.applicationConfig.isSetupComplete();
    }

    public void setSetupComplete(boolean complete) {
        this.applicationConfig.setSetupComplete(complete);
    }

    public String getBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    public void setBuildNumber(String buildNumber) {
        this.applicationConfig.setBuildNumber(buildNumber);
    }

    public Properties getHibernateProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.applicationConfig.getPropertiesWithPrefix("hibernate."));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapDatabase(DatabaseDetails dbDetails, boolean embedded) throws BootstrapException {
        try {
            this.hibernateConfigurator.configureDatabase(dbDetails, embedded);
        }
        catch (ConfigurationException e) {
            log.fatal((Object)("Could not successfully configure database: \n db: " + dbDetails + " \n embedded = " + embedded));
            log.fatal((Object)("ConfigurationException reads thus: " + e));
            this.hibernateConfigurator.unconfigureDatabase();
            throw new BootstrapException(e);
        }
        Connection conn = null;
        try {
            conn = this.getTestDatabaseConnection(dbDetails);
            if (!this.databaseContainsExistingData(conn)) {
                throw new BootstrapException("Schema creation complete, but database tables don't seem to exist.");
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
        this.postBootstrapDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapDatasource(String datasourceName, String hibernateDialect) throws BootstrapException {
        try {
            this.hibernateConfigurator.configureDatasource(datasourceName, hibernateDialect);
        }
        catch (ConfigurationException e) {
            log.fatal((Object)("Could not successfully configure datasource: \n db: " + datasourceName + " \n dialect = " + hibernateDialect));
            log.fatal((Object)("ConfigurationException reads thus: " + e));
            this.hibernateConfigurator.unconfigureDatabase();
            throw new BootstrapException(e);
        }
        Connection connection = null;
        try {
            connection = this.getTestDatasourceConnection(datasourceName);
            if (!this.databaseContainsExistingData(connection)) {
                throw new BootstrapException("Schema creation complete, but tables could not be found.");
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
        this.postBootstrapDatabase();
    }

    public Connection getTestDatabaseConnection(DatabaseDetails databaseDetails) throws BootstrapException {
        Connection conn = null;
        try {
            Class.forName(databaseDetails.getDriverClassName());
            conn = DriverManager.getConnection(this.getDbUrl(databaseDetails), databaseDetails.getUserName(), databaseDetails.getPassword());
            if (conn == null) {
                throw new BootstrapException("Connection was null. We could not successfully connect to the specified database!");
            }
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)"Could not successfully test your database: ", (Throwable)e);
            throw new BootstrapException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Could not successfully test your database: ", (Throwable)e);
            throw new BootstrapException(e);
        }
    }

    public Connection getTestDatasourceConnection(String datasourceName) throws BootstrapException {
        DataSource dsrc;
        log.debug((Object)("datasource is " + datasourceName));
        try {
            InitialContext ctx = new InitialContext();
            dsrc = (DataSource)ctx.lookup(datasourceName);
            if (dsrc == null) {
                throw new NamingException("Could not locate " + datasourceName);
            }
        }
        catch (NamingException e) {
            log.error((Object)("Could not locate datasource: " + datasourceName), (Throwable)e);
            throw new BootstrapException("Could not locate datasource: " + datasourceName, e);
        }
        catch (ClassCastException e) {
            log.error((Object)("Couldn't locate Datasource (" + datasourceName + ") in the initial context. An object was bound to this name but whatever we found, it wasn't a Datasource: " + e));
            throw new BootstrapException("Couldn't locate Datasource (" + datasourceName + ") in the initial context. An object was bound to this name but whatever we found, it wasn't a Datasource: ", e);
        }
        try {
            Connection conn = dsrc.getConnection();
            conn.createStatement();
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)("Couldn't open a connection on Datasource (" + datasourceName + "): " + e));
            throw new BootstrapException("Couldn't open a connection on Datasource (" + datasourceName + "): ", e);
        }
        catch (NullPointerException e) {
            log.error((Object)("Couldn't open a connection on Datasource (" + datasourceName + "): " + e));
            throw new BootstrapException("Couldn't open a connection on Datasource (" + datasourceName + "): ", e);
        }
    }

    public boolean databaseContainsExistingData(Connection connection) {
        for (String table : this.getTables()) {
            if (!this.tableExists(connection, table)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection conn, String table) {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.executeQuery("select count(*) from " + table);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public boolean isApplicationHomeValid() {
        return this.applicationConfig.isApplicationHomeValid();
    }

    protected boolean performPersistenceUpgrade() {
        return true;
    }

    protected void finishBootstrapInitialisation() throws ConfigurationException {
    }

    protected String getDbUrl(DatabaseDetails dbDetails) {
        return dbDetails.getDatabaseUrl();
    }

    protected void postBootstrapDatabase() {
    }

    protected void afterConfigurationLoaded() throws ConfigurationException {
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setHomeLocator(HomeLocator homeLocator) {
        this.homeLocator = homeLocator;
    }

    public void setSetupPersister(SetupPersister setupPersister) {
        this.setupPersister = setupPersister;
    }

    public HomeLocator getHomeLocator() {
        return this.homeLocator;
    }

    public ApplicationConfiguration getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getApplicationHome() {
        return this.applicationConfig.getApplicationHome();
    }

    public SetupPersister getSetupPersister() {
        return this.setupPersister;
    }

    public boolean isBootstrapped() {
        return this.bootstrapped;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public HibernateConfigurator getHibernateConfigurator() {
        return this.hibernateConfigurator;
    }

    public void setHibernateConfigurator(HibernateConfigurator hibernateConfigurator) {
        this.hibernateConfigurator = hibernateConfigurator;
    }

    public HibernateConfig getHibernateConfig() {
        return this.hibernateConfig;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public String getBootstrapFailureReason() {
        return this.bootstrapFailureReason;
    }

    public List getTables() {
        return this.tables;
    }

    public void setTables(List tables) {
        this.tables = tables;
    }
}

