/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config;

import com.atlassian.config.AbstractConfigurationPersister;
import com.atlassian.config.ConfigElement;
import com.atlassian.config.ConfigurationException;

public abstract class AbstractConfigElement
implements ConfigElement {
    private String propertyName;
    private AbstractConfigurationPersister config;

    public AbstractConfigElement(String name, Object context, AbstractConfigurationPersister config) {
        this.propertyName = name;
        this.setContext(context);
        this.config = config;
    }

    public final void save(Object object) throws ConfigurationException {
        this.checkSaveObject(object);
        this.saveConfig(object);
    }

    public final Object load() throws ConfigurationException {
        return this.loadConfig();
    }

    protected void checkSaveObject(Object object) throws ConfigurationException {
        if (object == null) {
            throw new ConfigurationException("Object to save cannot be null");
        }
        if (!this.getObjectClass().isAssignableFrom(object.getClass())) {
            throw new ConfigurationException("Object to save was not of expected type. Expected type was: " + this.getObjectClass() + ", actual type is: " + object.getClass().getName());
        }
    }

    public AbstractConfigurationPersister getConfiguration() {
        return this.config;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    protected abstract Object loadConfig() throws ConfigurationException;

    protected abstract void saveConfig(Object var1) throws ConfigurationException;
}

