/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.serializer;

import com.atlassian.asap.api.AlgorithmType;
import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.api.SigningAlgorithm;
import com.atlassian.asap.core.exception.SigningException;
import com.atlassian.asap.core.exception.UnsupportedAlgorithmException;
import com.atlassian.asap.core.serializer.JwtSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusJwtSerializer
implements JwtSerializer {
    private static final Logger logger = LoggerFactory.getLogger(NimbusJwtSerializer.class);

    @Override
    public String serialize(Jwt jwt, PrivateKey privateKey) throws SigningException, UnsupportedAlgorithmException {
        JWSObject jwsObject = this.getSignedJwsObject(jwt, privateKey);
        return jwsObject.serialize();
    }

    @VisibleForTesting
    JWSObject getSignedJwsObject(Jwt jwt, PrivateKey privateKey) throws UnsupportedAlgorithmException {
        SigningAlgorithm algorithm = jwt.getHeader().getAlgorithm();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.parse((String)algorithm.name())).keyID(jwt.getHeader().getKeyId()).build();
        Payload payload = new Payload(NimbusJwtSerializer.toJsonPayload(jwt.getClaims()));
        JWSObject jwsObject = new JWSObject(header, payload);
        try {
            jwsObject.sign(this.getSigner(algorithm, privateKey));
        }
        catch (JOSEException e) {
            logger.error("Unexpected error when signing JWT token", (Throwable)e);
            throw new SigningException();
        }
        return jwsObject;
    }

    private JWSSigner getSigner(SigningAlgorithm algorithm, PrivateKey privateKey) throws UnsupportedAlgorithmException {
        if ((algorithm.type() == AlgorithmType.RSA || algorithm.type() == AlgorithmType.RSASSA_PSS) && privateKey instanceof RSAPrivateKey) {
            return this.createRSASSASignerForKey((RSAPrivateKey)privateKey);
        }
        if (algorithm.type() == AlgorithmType.ECDSA && privateKey instanceof ECPrivateKey) {
            return this.createECDSASignerForKey((ECPrivateKey)privateKey);
        }
        throw new UnsupportedAlgorithmException(String.format("Unsupported algorithm %s or signing key type", algorithm.name()));
    }

    @VisibleForTesting
    protected JWSSigner createRSASSASignerForKey(RSAPrivateKey privateKey) {
        return new RSASSASigner(privateKey);
    }

    @VisibleForTesting
    protected JWSSigner createECDSASignerForKey(ECPrivateKey privateKey) {
        return new ECDSASigner(privateKey.getS());
    }

    private static JSONObject toJsonPayload(JwtClaims claims) {
        JSONObject claimsMap = new JSONObject();
        claimsMap.put((Object)JwtClaims.Claim.ISSUER.key(), (Object)claims.getIssuer());
        if (claims.getSubject().isPresent()) {
            claimsMap.put((Object)JwtClaims.Claim.SUBJECT.key(), (Object)claims.getSubject().get());
        }
        if (claims.getAudience().size() == 1) {
            claimsMap.put((Object)JwtClaims.Claim.AUDIENCE.key(), (Object)claims.getAudience().iterator().next());
        } else {
            claimsMap.put((Object)JwtClaims.Claim.AUDIENCE.key(), claims.getAudience());
        }
        claimsMap.put((Object)JwtClaims.Claim.JWT_ID.key(), (Object)claims.getJwtId());
        claimsMap.put((Object)JwtClaims.Claim.ISSUED_AT.key(), (Object)claims.getIssuedAt().getEpochSecond());
        claimsMap.put((Object)JwtClaims.Claim.EXPIRY.key(), (Object)claims.getExpiry().getEpochSecond());
        if (claims.getNotBefore().isPresent()) {
            claimsMap.put((Object)JwtClaims.Claim.NOT_BEFORE.key(), (Object)claims.getNotBefore().get().getEpochSecond());
        }
        return claimsMap;
    }
}

