/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.parser;

import com.atlassian.asap.api.AlgorithmType;
import com.atlassian.asap.api.JwsHeader;
import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtBuilder;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.api.SigningAlgorithm;
import com.atlassian.asap.core.exception.SignatureMismatchException;
import com.atlassian.asap.core.exception.UnsupportedAlgorithmException;
import com.atlassian.asap.core.parser.VerifiableJwt;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusVerifiableJwt
implements VerifiableJwt {
    private static final Logger logger = LoggerFactory.getLogger(NimbusVerifiableJwt.class);
    private final Jwt unverifiedJwt;
    private final JWSObject jwsObject;

    public NimbusVerifiableJwt(Jwt unverifiedJwt, JWSObject jwsObject) {
        this.unverifiedJwt = unverifiedJwt;
        this.jwsObject = jwsObject;
    }

    public static VerifiableJwt buildVerifiableJwt(JWSObject jwsObject, JWTClaimsSet claims) throws UnsupportedAlgorithmException {
        Jwt unverifiedJwt = JwtBuilder.newJwt().algorithm(NimbusVerifiableJwt.getSigningAlgorithm(jwsObject.getHeader().getAlgorithm().getName())).keyId(jwsObject.getHeader().getKeyID()).issuer(claims.getIssuer()).subject(Optional.ofNullable(claims.getSubject())).audience(claims.getAudience()).expirationTime(claims.getExpirationTime().toInstant()).issuedAt(claims.getIssueTime().toInstant()).notBefore(Optional.ofNullable(claims.getNotBeforeTime()).map(Date::toInstant)).build();
        return new NimbusVerifiableJwt(unverifiedJwt, jwsObject);
    }

    @Override
    public void verifySignature(PublicKey publicKey) throws SignatureMismatchException, UnsupportedAlgorithmException {
        try {
            if (!this.jwsObject.verify(NimbusVerifiableJwt.verifierFor(this.unverifiedJwt.getHeader().getAlgorithm(), publicKey))) {
                logger.debug("Invalid JWT signature");
                throw new SignatureMismatchException("Invalid JWT signature");
            }
        }
        catch (JOSEException e) {
            logger.error("Unexpected error when verifying a JWT signature", (Throwable)e);
            throw new SignatureMismatchException("Unexpected error when verifying JWT signature");
        }
    }

    private static JWSVerifier verifierFor(SigningAlgorithm algorithm, PublicKey publicKey) throws UnsupportedAlgorithmException {
        if ((algorithm.type() == AlgorithmType.RSA || algorithm.type() == AlgorithmType.RSASSA_PSS) && publicKey instanceof RSAPublicKey) {
            return new RSASSAVerifier((RSAPublicKey)publicKey);
        }
        if (algorithm.type() == AlgorithmType.ECDSA && publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            return new ECDSAVerifier(ecPublicKey.getW().getAffineX(), ecPublicKey.getW().getAffineY());
        }
        logger.debug("Unsupported signing algorithm {} or public key algorithm {}", (Object)algorithm, (Object)publicKey.getAlgorithm());
        throw new UnsupportedAlgorithmException(algorithm.name());
    }

    private static SigningAlgorithm getSigningAlgorithm(String algorithm) throws UnsupportedAlgorithmException {
        try {
            return SigningAlgorithm.valueOf(algorithm.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedAlgorithmException(algorithm + " is not a supported asymmetric JWS algorithm");
        }
    }

    @Override
    public JwsHeader getHeader() {
        return this.unverifiedJwt.getHeader();
    }

    @Override
    public JwtClaims getClaims() {
        return this.unverifiedJwt.getClaims();
    }
}

