/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataUriUtil {
    private static Pattern DATA_URI_PATTERN = Pattern.compile("data:(?<mimeType>[\\w\\-]+/[\\w\\-]+);kid=(?<keyId>[\\w.\\-\\+%]*);base64,(?<encodedData>[A-Za-z0-9+/=]+)");

    public static byte[] getKeyData(String dataUri) {
        String rawKeyData = DataUriUtil.getParameterFromDataUri(dataUri, "encodedData");
        return Base64.getDecoder().decode(rawKeyData);
    }

    public static String getKeyId(String dataUri) {
        String rawKeyId = DataUriUtil.getParameterFromDataUri(dataUri, "keyId");
        try {
            return URLDecoder.decode(rawKeyId, StandardCharsets.US_ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not decode key id parameter in data uri. Key id must be url encoded.", e);
        }
    }

    private static String getParameterFromDataUri(String dataUri, String parameter) {
        Matcher dataUriMatcher = DATA_URI_PATTERN.matcher(dataUri);
        if (!dataUriMatcher.matches() || dataUriMatcher.groupCount() != 3) {
            throw new IllegalArgumentException("Unable to parse data uri parameter: " + parameter);
        }
        return dataUriMatcher.group(parameter);
    }
}

