/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.api;

import com.atlassian.asap.api.JwsHeader;
import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.api.SigningAlgorithm;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class JwtBuilder {
    public static final Duration DEFAULT_LIFETIME = Duration.ofSeconds(60L);
    private SigningAlgorithm alg;
    private String keyId;
    private String iss;
    private Optional<String> sub;
    private Iterable<String> aud;
    private Instant iat;
    private Instant exp;
    private Optional<Instant> nbf;
    private String jti;

    private JwtBuilder() {
        Instant now = Instant.now();
        this.notBefore(Optional.of(now));
        this.issuedAt(now);
        this.expirationTime(now.plus(DEFAULT_LIFETIME));
        this.jwtId(UUID.randomUUID().toString());
        this.algorithm(SigningAlgorithm.RS256);
        this.sub = Optional.empty();
    }

    public static JwtBuilder newJwt() {
        return new JwtBuilder();
    }

    public static JwtBuilder copyJwt(Jwt prototype) {
        return new JwtBuilder().algorithm(prototype.getHeader().getAlgorithm()).keyId(prototype.getHeader().getKeyId()).issuer(prototype.getClaims().getIssuer()).subject(prototype.getClaims().getSubject()).audience(prototype.getClaims().getAudience()).issuedAt(prototype.getClaims().getIssuedAt()).expirationTime(prototype.getClaims().getExpiry()).notBefore(prototype.getClaims().getNotBefore()).jwtId(prototype.getClaims().getJwtId());
    }

    public JwtBuilder keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public JwtBuilder algorithm(SigningAlgorithm alg) {
        this.alg = alg;
        return this;
    }

    public JwtBuilder audience(Iterable<String> aud) {
        this.aud = ImmutableSet.copyOf(aud);
        return this;
    }

    public JwtBuilder audience(String ... aud) {
        this.aud = ImmutableSet.copyOf((Object[])aud);
        return this;
    }

    public JwtBuilder expirationTime(Instant expiry) {
        this.exp = expiry;
        return this;
    }

    public JwtBuilder issuedAt(Instant iat) {
        this.iat = iat;
        return this;
    }

    public JwtBuilder issuer(String iss) {
        this.iss = iss;
        return this;
    }

    public JwtBuilder jwtId(String jti) {
        this.jti = jti;
        return this;
    }

    public JwtBuilder notBefore(Optional<Instant> nbf) {
        this.nbf = nbf;
        return this;
    }

    public JwtBuilder subject(Optional<String> sub) {
        this.sub = sub;
        return this;
    }

    public Jwt build() {
        ImmutableJwsHeader header = new ImmutableJwsHeader(this.alg, this.keyId);
        ImmutableJwtClaims claims = new ImmutableJwtClaims(this.iss, this.sub, this.aud, this.exp, this.nbf, this.iat, this.jti);
        return new ImmutableJwt(header, claims);
    }

    private static class ImmutableJwtClaims
    implements JwtClaims {
        private final String iss;
        private final Optional<String> sub;
        private final Set<String> aud;
        private final Instant expiry;
        private final Optional<Instant> notBefore;
        private final Instant issuedAt;
        private final String jwtId;

        ImmutableJwtClaims(String iss, Optional<String> sub, Iterable<String> aud, Instant exp, Optional<Instant> nbf, Instant iat, String jti) {
            this.iss = Objects.requireNonNull(iss, "JWT claim 'iss' cannot be null");
            this.sub = Objects.requireNonNull(sub, "JWT claim 'sub' cannot be null (but it can be None)");
            this.aud = ImmutableSet.copyOf(Objects.requireNonNull(aud, "JWT claim 'aud' cannot be null"));
            this.issuedAt = Objects.requireNonNull(iat, "JWT claim 'iat' cannot be null");
            this.expiry = Objects.requireNonNull(exp, "JWT claim 'exp' cannot be null");
            this.notBefore = Objects.requireNonNull(nbf, "JWT claim 'nbf' cannot be null (but it can be None)");
            this.jwtId = Objects.requireNonNull(jti, "JWT claim 'jit' cannot be null");
        }

        @Override
        public String getIssuer() {
            return this.iss;
        }

        @Override
        public Optional<String> getSubject() {
            return this.sub;
        }

        @Override
        public Set<String> getAudience() {
            return this.aud;
        }

        @Override
        public Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public Optional<Instant> getNotBefore() {
            return this.notBefore;
        }

        @Override
        public Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public String getJwtId() {
            return this.jwtId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(JwtClaims.Claim.ISSUER.key(), (Object)this.iss).append(JwtClaims.Claim.SUBJECT.key(), this.sub).append(JwtClaims.Claim.AUDIENCE.key(), this.aud).append(JwtClaims.Claim.ISSUED_AT.key(), (Object)this.issuedAt).append(JwtClaims.Claim.EXPIRY.key(), (Object)this.expiry).append(JwtClaims.Claim.NOT_BEFORE.key(), this.notBefore).append(JwtClaims.Claim.JWT_ID.key(), (Object)this.jwtId).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwtClaims rhs = (ImmutableJwtClaims)o;
            return new EqualsBuilder().append((Object)this.iss, (Object)rhs.iss).append(this.sub, rhs.sub).append(this.aud, rhs.aud).append((Object)this.issuedAt, (Object)rhs.issuedAt).append((Object)this.expiry, (Object)rhs.expiry).append(this.notBefore, rhs.notBefore).append((Object)this.jwtId, (Object)rhs.jwtId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.iss).append(this.sub).append(this.aud).append((Object)this.issuedAt).append((Object)this.expiry).append(this.notBefore).append((Object)this.jwtId).hashCode();
        }
    }

    private static final class ImmutableJwsHeader
    implements JwsHeader {
        private final SigningAlgorithm algorithm;
        private final String keyId;

        ImmutableJwsHeader(SigningAlgorithm algorithm, String keyId) {
            this.algorithm = Objects.requireNonNull(algorithm, "JWT header 'alg' cannot be null");
            this.keyId = Objects.requireNonNull(keyId, "JWT header 'kid' cannot be null");
        }

        @Override
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        public SigningAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(JwsHeader.Header.ALGORITHM.key(), (Object)this.algorithm).append(JwsHeader.Header.KEY_ID.key(), (Object)this.keyId).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwsHeader rhs = (ImmutableJwsHeader)o;
            return new EqualsBuilder().append((Object)this.algorithm, (Object)rhs.algorithm).append((Object)this.keyId, (Object)rhs.keyId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.algorithm).append((Object)this.keyId).hashCode();
        }
    }

    private static class ImmutableJwt
    implements Jwt {
        private final JwsHeader header;
        private final JwtClaims claimsSet;

        ImmutableJwt(JwsHeader header, JwtClaims claims) {
            this.header = Objects.requireNonNull(header);
            this.claimsSet = Objects.requireNonNull(claims);
        }

        @Override
        public JwsHeader getHeader() {
            return this.header;
        }

        @Override
        public JwtClaims getClaims() {
            return this.claimsSet;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("header", (Object)this.header).append("claims", (Object)this.claimsSet).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwt rhs = (ImmutableJwt)o;
            return new EqualsBuilder().append((Object)this.header, (Object)rhs.header).append((Object)this.claimsSet, (Object)rhs.claimsSet).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.header).append((Object)this.claimsSet).hashCode();
        }
    }
}

