AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var H=require("workflow-designer/layout/locator/manhattan-percentage-locator");var F=require("workflow-designer/policy/feedback/line-selection-feedback-policy");var A=require("workflow-designer/status-model");var J=require("workflow-designer/status-view");var C=require("workflow-designer/workflow-model");var B=require("workflow-designer/transition-connection");var G=require("workflow-designer/policy/canvas/panning-single-selection-policy");var K=require("workflow-designer/direction");var L=require("jquery");var I=require("workflow-designer/underscore");var E=require("workflow-designer/draw-2d");var D=require("workflow-designer/test-utilities");module("TransitionConnection",{allPortsAreVisible:function(M){return this.checkPortsVisibility(M,[])},checkPortsVisibility:function(M,N){return I.all(M.getPorts(),function(O,P){if(I.contains(N,P)){return !O.isVisible()}return O.isVisible()})},createTestData:function(M){this.sourceView=new J({canvas:this.canvas,model:new A({x:10,y:0}),workflowModel:new C(),isPortDragged:L.noop,getAllTargetPorts:I.bind(this._getAllPorts,this)}).render();this.targetView=new J({canvas:this.canvas,model:new A({x:200,y:0}),workflowModel:new C(),isPortDragged:L.noop,getAllTargetPorts:I.bind(this._getAllPorts,this)}).render();this.transitionConnection=new B(!!M);this.transitionConnection.installEditPolicy(new F());this.transitionConnection.setSource(this.sourceView.getPorts()[0]);this.transitionConnection.setTarget(this.targetView.getPorts()[0]);this.canvas.addFigure(this.transitionConnection)},_getAllPorts:function(){return I.union(this.sourceView.getPorts(),this.targetView.getPorts())},selectTransition:function(){this.canvas.selectFigure(this.transitionConnection)},setup:function(){function M(){return new E.geo.Rectangle(0,0,0,0)}this.sandbox=sinon.sandbox.create();this.canvas=D.testDraw2DCanvas();this.selectionPolicy=new G(M)},teardown:function(){this.sandbox.restore()}});test("Changing source port should relocate the transition label",function(){var M;this.createTestData();M=this.sandbox.stub(H.prototype,"relocate");this.transitionConnection.setSource(this.sourceView.getPorts()[0]);equal(M.callCount,1,"relocate() should be called once")});test("Changing target port should relocate the transition label",function(){var M;this.createTestData();M=this.sandbox.stub(H.prototype,"relocate");this.transitionConnection.setTarget(this.sourceView.getPorts()[0]);equal(M.callCount,1,"relocate() should be called once")});test("Label text is truncated if maximum length is exceeded",function(){var M=new B();M._getEllipsis=sinon.stub().returns("\u2026");M.setText(null);equal(M._label.getText(),undefined,"Null label stays null");M.setText("12345");equal(M._label.getText(),"12345","Label shorter than maximum is not truncated");M.setText("123456789 123456789 123456789 ");equal(M._label.getText(),"123456789 123456789 123456789 ","Label equal to maximum is not truncated");M.setText("123456789 123456789 123456789 123456789");equal(M._label.getText(),"123456789 123456789 123456789\u2026","Label longer than maximum is truncated and ellipsis is appended")});test("Transitions should have a gap",function(){var M=new B(false);sinon.stub(M,"getTarget").returns({getConnectionDirection:function(){return K.RIGHT}});sinon.stub(M,"getSource").returns({getConnectionDirection:function(){return K.RIGHT}});deepEqual(M.getEndPointGapTransformation(),{x:3,y:0},"The end point should have a gap of 3 pixels");deepEqual(M.getStartPointGapTransformation(),{x:3,y:0},"The start point should have a gap of 3 pixels")});test("Global Transitions should have a gap only in the endpoint",function(){var M=new B(true);sinon.stub(M,"getTarget").returns({getConnectionDirection:function(){return K.RIGHT}});sinon.stub(M,"getSource").returns({getConnectionDirection:function(){return K.RIGHT}});deepEqual(M.getEndPointGapTransformation(),{x:3,y:0},"The end point should have a gap of 3 pixels");deepEqual(M.getStartPointGapTransformation(),{x:0,y:0},"The start point should have a gap of 3 pixels")});test("Status target ports are shown when connection start/end is dragged",function(){var O,N,M;this.createTestData();this.selectTransition();N=this.transitionConnection.selectionHandles;M=N.get(0);O=N.get(1);ok(L(M.shape).is(":visible"),"Start resize handler is visible");ok(L(O.shape).is(":visible"),"End resize handler is visible");ok(!this.allPortsAreVisible(this.sourceView),"All ports in the source are not visible before drag");ok(!this.allPortsAreVisible(this.targetView),"All ports in the target are not visible before drag");M.onDragStart();ok(this.allPortsAreVisible(this.sourceView),"When resizing from the start, all ports in the source are visible on drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the start, all ports in the target are not visible on drag");M.onDragEnd();ok(!this.allPortsAreVisible(this.sourceView),"When resizing from the start, all ports in the source are not visible after drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the start, all ports in the target are not visible after drag");O.onDragStart();ok(this.checkPortsVisibility(this.sourceView,[0]),"When resizing from the end, all ports in the source except the opposite port are visible on drag");ok(this.allPortsAreVisible(this.targetView),"When resizing from the end, all ports in the target are visible on drag");O.onDragEnd();ok(!this.allPortsAreVisible(this.sourceView),"When resizing from the end, all ports in the source are not visible after drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the end, all ports in the target are not visible after drag")});test("Connection's port is hidden when the opposite port is dragged",function(){var O,P,N,M,Q;O=new J({canvas:this.canvas,model:new A({x:10,y:0}),workflowModel:new C(),isPortDragged:L.noop,getAllTargetPorts:function(){return O.getPorts()}}).render();P=new B(false);P.installEditPolicy(new F());P.setSource(O.getPorts()[0]);P.setTarget(O.getPorts()[1]);this.canvas.addFigure(P);this.canvas.selectFigure(P);N=P.selectionHandles;M=N.get(0);Q=N.get(1);M.onDragStart();ok(this.checkPortsVisibility(O,[1]),"When resizing from the start, all ports except the port #1 are visible");M.onDragEnd();Q.onDragStart();ok(this.checkPortsVisibility(O,[0]),"When resizing from the start, all ports except the port #0 are visible");Q.onDragEnd()});test("The label is always visible on the Initial transitions",function(){this.createTestData(true);ok(this.transitionConnection.textIsVisible(),"The transition's label is visible")});test("Start resize handler is not visible on Initial transition",function(){this.createTestData(true);this.selectTransition();ok(!L(this.transitionConnection.selectionHandles.get(0).shape).is(":visible"),"Start resize handler is invisible");ok(L(this.transitionConnection.selectionHandles.get(1).shape).is(":visible"),"End resize handler is visible")});test("Clicking a transition's label selects the transition",function(){this.createTestData();sinon.stub(this.canvas,"getBestFigure").returns(this.transitionConnection._label);this.selectionPolicy.onMouseDown(this.canvas,0,0);ok(this.canvas.getSelectedFigure()===this.transitionConnection,"The transition was selected")});test("Line start handle's onDragEnd operation does nothing when moused over a drop target and dropped on nothing",function(){var N,M;this.createTestData();this.selectTransition();M=this.sourceView.getPorts()[0];N=this.transitionConnection.selectionHandles.get(0);N.onDragStart();var O=this.sandbox.stub(N,"_getDropTarget").returns(this.sourceView.getPorts()[1]);N.onDrag(0,0);O.returns(null);N.onDrag(0,0);N.onDragEnd();ok(this.transitionConnection.getSource()===M,"The source port should revert back to the original port.")});test("Line start handle's onDragEnd undoes operation when dropped on a drop target",function(){var M,N;this.createTestData();this.selectTransition();N=this.sourceView.getPorts()[1];M=this.transitionConnection.selectionHandles.get(0);M.onDragStart();this.sandbox.stub(M,"_getDropTarget").returns(N);M.onDrag(0,0);M.onDragEnd();ok(this.transitionConnection.getSource()===N,"The source after drag end should be the moused over port.")});test("#positionArrow sets the target decorator's z-index",function(){var M;this.createTestData();M=sinon.spy(this.transitionConnection.targetDecoratorNode,"insertAfter");this.transitionConnection.positionArrow();equal(M.callCount,1,"The target decorator's insertAfter method was called");ok(M.args[0][0]===this.transitionConnection.shape,"It was passed the correct argument")})});