define("workflow-designer/looped-transition-container-figure", [
    "workflow-designer/layout/locator/looped-transition-locator",
    "workflow-designer/draw-2d"
], function(
    LoopedTransitionLocator,
    draw2d
) {
    return draw2d.shape.basic.Rectangle.extend(
    /** @lends JIRA.WorkflowDesigner.LoopedTransitionContainerFigure# */
    {
        init: function () {
            this._super.apply(this, arguments);
            this._locator = new LoopedTransitionLocator();
            this.installEditPolicy(new draw2d.policy.figure.SelectionFeedbackPolicy());
            this.setBackgroundColor("#ffffff");
            this.setColor("#cccccc");
            this.setStroke(1);
            this.snapToGeometry = true;
            this.allowSelectionIfAlreadySelected = true;
        },

        addTransitionFigure: function(transitionFigure) {
            this.addFigure(transitionFigure, this._locator);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.LoopedTransitionContainerFigure", null, require("workflow-designer/looped-transition-container-figure"));