AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var GlobalTransitionView = require("workflow-designer/global-transition-view");
    var StatusModel = require("workflow-designer/status-model");
    var TransitionModel = require("workflow-designer/transition-model");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("GlobalTransitionView", {
        /**
         * @return {JIRA.WorkflowDesigner.TransitionView} A newly created `GlobalTransitionView`.
         */
        createGlobalTransitionView: function () {
            var statusModel = new StatusModel();
            this.canvasView.addStatus(statusModel);

            return this.canvasView.addTransition(new TransitionModel({
                globalTransition: true,
                target: statusModel
            }));
        },

        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.canvasView = TestUtilities.testCanvasView();
            this.editStub = this.sandbox.stub(GlobalTransitionView.prototype, "edit");
        },

        teardown: function () {
            TestUtilities.removeDialogs();
            this.sandbox.restore();
        }
    });

    test("Double clicking a global transition initiates editing", function () {
        TestUtilities.fakeTimer(function () {
            var globalTransitionView;

            globalTransitionView = this.createGlobalTransitionView();
            globalTransitionView._figure.onDoubleClick();
            equal(this.editStub.callCount, 1, "GlobalTransitionView#edit() was called");
        }, this);
    });

    test("Double clicking a global transition doesn't initiate editing when immutable", function () {
        TestUtilities.fakeTimer(function () {
            var globalTransitionView;

            this.canvasView = TestUtilities.testCanvasView({immutable: true});
            globalTransitionView = this.createGlobalTransitionView();
            globalTransitionView._figure.onDoubleClick();
            equal(this.editStub.callCount, 0, "GlobalTransitionView#edit() wasn't called when immutable");
        }, this);
    });

    test("The figure is added to the \"global-transitions\" layer", function () {
        TestUtilities.fakeTimer(function () {
            var figure,
                layer = this.canvasView.canvas.getLayer("global-transitions");

            sinon.spy(layer, "addFigure");
            figure = this.createGlobalTransitionView()._figure;

            equal(layer.addFigure.callCount, 1, "The global-transitions layer's #addFigure() method was called");
            ok(layer.addFigure.args[0][0] === figure, "It was passed the correct figure");
        }, this);
    });

    test("The figure is moved to the \"selected-transition\" layer on selection", function () {
        TestUtilities.fakeTimer(function () {
            var globalTransitionsLayer = this.canvasView.canvas.getLayer("global-transitions"),
                selectedTransitionLayer = this.canvasView.canvas.getLayer("selected-transition"),
                view = this.createGlobalTransitionView();

            sinon.spy(globalTransitionsLayer, "addFigure");
            sinon.spy(selectedTransitionLayer, "addFigure");

            view.select();
            equal(selectedTransitionLayer.addFigure.callCount, 1, "The selected-transition layer's #addFigure() method was called");
            ok(selectedTransitionLayer.addFigure.args[0][0] === view._figure, "It was passed the correct figure");

            view.deselect();
            equal(globalTransitionsLayer.addFigure.callCount, 1, "The global-transition layer's #addFigure() method was called");
            ok(globalTransitionsLayer.addFigure.args[0][0] === view._figure, "It was passed the correct figure");
        }, this);
    });

});
