AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var B=require("workflow-designer/dialogs/delete-status-dialog-view");var G=require("workflow-designer/status-lozenge-colours");var D=require("workflow-designer/status-model");var F=require("workflow-designer/status-view");var H=require("workflow-designer/workflow-model");var A=require("workflow-designer/test-utilities");var C=require("workflow-designer/underscore");var E=require("workflow-designer/draw-2d");module("StatusView",{allPortsAreVisible:function(I){return C.all(I.getPorts(),function(J){return J.isVisible()})},createStatusView:function(K){var J=C.bind(this.canvasView._getAllTargetPorts,this.canvasView),L=C.bind(this.canvasView._isPortDragged,this.canvasView),I;K=C.defaults({},K,{canvas:this.canvas,model:new D(),getAllTargetPorts:J,isPortDragged:L,workflowModel:this.workflowModel});I=new F(K).render();this.canvasView.statusViews.add(I);return I},noPortsAreVisible:function(I){return C.all(I.getPorts(),function(J){return !J.isVisible()})},setup:function(){this.canvasView=A.testCanvasView();this.canvas=this.canvasView.canvas;this.sandbox=sinon.sandbox.create();this.workflowModel=new H()},teardown:function(){A.removeDialogs();this.sandbox.restore()}});test("All ports are visible while dragging",function(){var K,J,I;K=this.createStatusView();ok(this.noPortsAreVisible(K),"Ports aren't visible initially");I=this.createStatusView();ok(this.noPortsAreVisible(I),"Ports aren't visible initially");J=I.getPorts()[0];J.onDragStart();ok(this.allPortsAreVisible(K),"All ports are visible on the target status");ok(C.all(C.tail(I.getPorts()),function(L){return L.isVisible()}),"All ports are visible on the source status except the one being dragged");J.onDragEnd();ok(this.noPortsAreVisible(K),"No ports are visible on the target status");ok(this.allPortsAreVisible(I),"All ports are visible on the source status")});test("destroy() shows a DeleteStatusDialogView",function(){var K,J=this.sandbox.stub(B.prototype,"initialize").returns(jQuery.noop),I=this.createStatusView();this.sandbox.stub(B.prototype,"show").returns(jQuery.noop),I.destroy();equal(J.callCount,1,"A DeleteStatusDialogView was created");K=J.args[0];equal(K.length,1,"It was passed a single argument");equal(K[0].statusModel,I.model,"It was passed the correct StatusModel");equal(K[0].workflowModel,this.workflowModel,"It was passed the correct WorkflowModel")});test("Double clicking a status doesn't initiate editing when immutable",function(){var J=this.sandbox.stub(F.prototype,"edit"),I=this.createStatusView({immutable:true});I._figure.onDoubleClick();equal(J.callCount,0,"StatusView#edit() wasn't called")});test("Double clicking a status initiates editing",function(){this.workflowModel.get("permissions").set("editStatus",true);var J=this.sandbox.stub(F.prototype,"edit"),I=this.createStatusView();I._figure.onDoubleClick();equal(J.callCount,1,"StatusView#edit() was called.")});test("Drag events are triggered",function(){var J;function I(K){var L=sinon.spy(),M=sinon.spy();K.bind("drag",M);K.bind("dragEnd",L);K._figure.onDrag();equal(M.callCount,1,"A drag event was triggered");K._figure.command=K._figure.createCommand(new E.command.CommandType(E.command.CommandType.MOVE));K._figure.onDragEnd();equal(L.callCount,1,"A dragEnd event was triggered")}J=[this.createStatusView(),this.createStatusView({immutable:true})];C.each(J,I)});test("Dragging a port selects the associated status",function(){var I=this.createStatusView();ok(!I.isSelected(),"The status isn't selected");I.getPorts()[0].onDragStart();ok(I.isSelected(),"The status is selected")});test("Dragging the view updates model coordinates",function(){var I;I=this.createStatusView();I.getBoundingBox=function(){return new E.geo.Rectangle(100,200,10,10)};I._figure.onDragStart();I._figure.onDragEnd();equal(I.model.get("x"),100,"The model's x coordinate was updated");equal(I.model.get("y"),200,"The model's y coordinate was updated")});test("Highlight events are triggered on hover",function(){var J;function I(K){var L=sinon.spy(),M=sinon.spy();K.bind("highlight",L);K.bind("unhighlight",M);K._figure.onMouseEnter();equal(L.callCount,1,"A highlight event was fired");K._figure.onMouseLeave();equal(M.callCount,1,"An unhighlight event was fired")}J=[this.createStatusView(),this.createStatusView({immutable:true})];C.each(J,I)});test("Statuses are the correct colour when status lozenges are available",function(){var J,I;this.sandbox.stub(G,"getBackgroundColour").returns("#ff0000");this.sandbox.spy(G,"getBorderColour");this.sandbox.stub(G,"getColour").returns("#00ff00");I=this.createStatusView({model:new D({statusCategory:{colourName:"green",id:1}})});J=[{colourName:"green",isSubtle:false}];equal(G.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(G.getBackgroundColour.args[0],J,"It was passed the correct arguments");equal(G.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(G.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(G.getColour.args[0],J,"It was passed the correct arguments");equal(I._figure.getBackgroundColor().hash(),"#FF0000","The status has the correct background colour");equal(I._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(I._figure.getTextColor().hash(),"#00FF00","The status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available",function(){var I=this.createStatusView();equal(I._figure.getBackgroundColor().hash(),"#4A6785","The status has the correct background colour");equal(I._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(I._figure.getTextColor().hash(),"#FFFFFF","The status has the correct text colour")});test("Ports are shown on hover",function(){var I=this.createStatusView();ok(this.noPortsAreVisible(I),"Ports aren't visible initially");I._figure.onMouseEnter();ok(this.allPortsAreVisible(I),"Ports become visible on hover");I._figure.onMouseLeave();ok(this.noPortsAreVisible(I),"Ports are hidden on mouse leave")});test("Ports are shown on port hover",function(){var J,I;I=this.createStatusView();J=I.getPorts()[0];ok(this.noPortsAreVisible(I),"Ports aren't visible initially");J.onMouseEnter();ok(this.allPortsAreVisible(I),"Ports become visible on port hover");J.onMouseLeave();ok(this.noPortsAreVisible(I),"Ports are hidden on mouse leave")});test("Ports aren't hidden after moving from the status body to a port",function(){var J,I;I=this.createStatusView();J=I.getPorts()[0];ok(this.noPortsAreVisible(I),"Ports aren't visible initially");I._figure.onMouseEnter();ok(this.allPortsAreVisible(I),"Ports become visible on hover");I._figure.onMouseLeave(J);ok(this.allPortsAreVisible(I),"Ports are still visible as the new figure is a port");J.onMouseLeave(I._figure);ok(this.allPortsAreVisible(I),"Ports are still visible as the new figure is the status")});test("Ports aren't shown on hover when immutable",function(){var I=this.createStatusView({immutable:true});ok(this.noPortsAreVisible(I),"Ports aren't visible initially");I._figure.onMouseEnter();ok(this.noPortsAreVisible(I),"Ports aren't visible on hover")});test("Statuses are the correct colour when status lozenges are available in subtle mode",function(){var I,K,J;this.sandbox.stub(G,"getBackgroundColour").returns("#ff0000");this.sandbox.stub(G,"getBorderColour").returns("#00ff00");this.sandbox.stub(G,"getColour").returns("#0000ff");this.canvasView=A.testCanvasView({workflowModel:new H({currentStepId:1})});I=this.canvasView.addStatus(new D({statusCategory:{colourName:"green",id:1},stepId:1}));K=[{colourName:"green",isSubtle:false}];equal(G.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(G.getBackgroundColour.args[0],K,"It was passed the correct arguments");equal(G.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(G.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(G.getColour.args[0],K,"It was passed the correct arguments");equal(I._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(I._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(I._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour");J=this.canvasView.addStatus(new D({statusCategory:{colourName:"yellow",id:2},stepId:2}));K=[{colourName:"yellow",isSubtle:true}];equal(G.getBackgroundColour.callCount,2,"StatusLozengeColours.getBackgroundColour was called");deepEqual(G.getBackgroundColour.args[1],K,"It was passed the correct arguments");equal(G.getBorderColour.callCount,1,"StatusLozengeColours.getBorderColour was called");deepEqual(G.getBorderColour.args[0],K,"It was passed the correct arguments");equal(G.getColour.callCount,2,"StatusLozengeColours.getColour was called");deepEqual(G.getColour.args[1],K,"It was passed the correct arguments");equal(J._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(J._figure.getColor().hash(),"#00FF00","The current status has the correct border colour");equal(J._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available in subtle mode",function(){var I,J;this.canvasView=A.testCanvasView({workflowModel:new H({currentStepId:1})});I=this.canvasView.addStatus(new D({stepId:1}));equal(I._figure.getBackgroundColor().hash(),"#4A6785","The current status has the correct background colour");equal(I._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(I._figure.getTextColor().hash(),"#FFFFFF","The current status has the correct text colour");J=this.canvasView.addStatus(new D({stepId:2}));equal(J._figure.getBackgroundColor().hash(),"#FFFFFF","The other status has the correct background colour");equal(J._figure.getColor().hash(),"#4A6785","The other status has the correct border colour");equal(J._figure.getTextColor().hash(),"#4A6785","The other status has the correct text colour")});test('The figure is added to the "selected-status" layer on selection',function(){var K=this.canvas.getLayer("selected-status"),J=this.canvas.getLayer("statuses"),I=this.createStatusView();sinon.spy(K,"addFigure");sinon.spy(J,"addFigure");I.select();equal(K.addFigure.callCount,1,'The "selected-status" layer\'s #addFigure() method was called');ok(K.addFigure.args[0][0]===I._figure,"It was passed the correct figure");I.deselect();equal(J.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(J.addFigure.args[0][0]===I._figure,"It was passed the correct figure")});test('The figure is added to the "statuses" layer',function(){var J=this.canvas.getLayer("statuses"),I;sinon.spy(J,"addFigure");I=this.createStatusView();equal(J.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(J.addFigure.args[0][0]===I._figure,"It was passed the correct figure")})});