AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StatusFigure = require("workflow-designer/status-figure");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("StatusFigure", {
        /**
         * Create a status figure and add it to the canvas.
         *
         * @returns {JIRA.WorkflowDesigner.StatusFigure} The new status figure.
         */
        createStatusFigure: function () {
            var statusFigure = new StatusFigure();
            this.canvas.addFigure(statusFigure);
            return statusFigure;
        },

        setup: function () {
            this.canvas = TestUtilities.testDraw2DCanvas();
        }
    });

    test("Can be (de)selected", function () {
        var statusFigure = this.createStatusFigure();

        statusFigure.select();
        ok(statusFigure._selectedOutline.isVisible(), "The figure is highlighted");

        statusFigure.unselect();
        ok(!statusFigure._selectedOutline.isVisible(), "The figure isn't highlighted");
    });

    test("Has a minimum width", function () {
        var statusFigure, width;

        statusFigure = this.createStatusFigure();
        statusFigure.setText("");

        width = statusFigure.getBoundingBox().getWidth();
        equal(width, 60, "The figure has a minimum width");
    });

    test("Resizes to fit its label", function () {
        var actualWidth, expectedWidth, statusFigure;

        statusFigure = this.createStatusFigure();
        statusFigure.setText("Hello, world!");

        actualWidth = statusFigure.getBoundingBox().getWidth();
        expectedWidth = statusFigure._label.getBoundingBox().getWidth() + 40;
        equal(actualWidth, expectedWidth, "The figure is wider than its label");
    });

    test("setBackgroundColor()", function () {
        var statusFigure = this.createStatusFigure();
        sinon.spy(statusFigure._fill, "setBackgroundColor");

        statusFigure.setBackgroundColor("#ff0000");
        equal(statusFigure._fill.setBackgroundColor.callCount, 1, "_fill.setBackgroundColor was called");
        equal(statusFigure._fill.setBackgroundColor.args[0][0], "#ff0000", "It was passed the correct argument");
    });

    test("setColor()", function () {
        var statusFigure = this.createStatusFigure();
        sinon.spy(statusFigure._edge, "setBackgroundColor");

        statusFigure.setColor("#ff0000");
        equal(statusFigure._edge.setBackgroundColor.callCount, 1, "_edge.setBackgroundColor was called");
        equal(statusFigure._edge.setBackgroundColor.args[0][0], "#ff0000", "It was passed the correct argument");
    });

    test("setTextColor()", function () {
        var statusFigure = this.createStatusFigure();
        sinon.spy(statusFigure._label, "setFontColor");

        statusFigure.setTextColor("#ff0000");
        equal(statusFigure._label.setFontColor.callCount, 1, "_label.setFontColor was called");
        equal(statusFigure._label.setFontColor.args[0][0], "#ff0000", "It was passed the correct argument");
    });

});
