AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StatusModel = require("workflow-designer/status-model");
    var InitialStatusView = require("workflow-designer/initial-status-view");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("InitialStatusView", {
        setup: function () {
            this.canvas = TestUtilities.testDraw2DCanvas();
            this.sandbox = sinon.sandbox.create();
        },

        teardown: function () {
            this.sandbox.restore();
        },

        createStatusView: function () {
            return new InitialStatusView({
                canvas: this.canvas,
                model: new StatusModel()
            }).render();
        }
    });

    test("Hovering over the view triggers highlight/unhighlight events", function () {
        var highlightSpy = this.sandbox.spy(),
            statusView = this.createStatusView(),
            unhighlightSpy = this.sandbox.spy();

        statusView.on("highlight", highlightSpy);
        statusView.on("unhighlight", unhighlightSpy);

        statusView._fill.onMouseEnter();
        equal(highlightSpy.callCount, 1, "A highlight event was triggered on mouse enter");

        statusView._fill.onMouseLeave();
        equal(unhighlightSpy.callCount, 1, "An unhighlight event was triggered on mouse leave");
    });

});
