define("workflow-designer/properties-panel/transition-properties-view", [
    "workflow-designer/internal-api/panel-service",
    "workflow-designer/properties-panel/properties-view",
    "workflow-designer/browser-utilities",
    "workflow-designer/global-transition-view",
    "workflow-designer/looped-transition-view",
    "workflow-designer/transition-view",
    "workflow-designer/templates",
    "workflow-designer/backbone",
    "workflow-designer/underscore",
    "jquery"
], function(
    PanelService,
    PropertiesView,
    BrowserUtilities,
    GlobalTransitionView,
    LoopedTransitionView,
    TransitionView,
    Templates,
    Backbone,
    _,
    $
) {
    /**
     * @class JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView
     * @classdesc The content of the properties panel when a transition is selected.
     * @extends JIRA.WorkflowDesigner.PropertiesPanel
     */
    return PropertiesView.extend(
    /** @lends JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView# */
    {
        events: {
            "click .delete": "_destroy",
            "click .edit": "_edit",
            "click .show-conditions-quick-fix": function() { this._openConditions(); }
        },

        template: Templates.PropertiesPanel.transition,

        _openConditions: function() {
            window.open($("a[href*='descriptorTab=conditions']")[0].href, '_blank');
        },

        /**
         * @return {string} The query string common to all links.
         * @private
         */
        _getQueryString: function () {
            var isInitial = this._selectedView.model.isInitial(),
                isGlobal = this._selectedView.model.isGlobalTransition(),
                parameters = {};

            if (!isInitial && !isGlobal) {
                parameters.workflowStep = this._selectedView.model.getSourceStepId();
            }

            return BrowserUtilities.makeQueryString(parameters);
        },

        /**
         * @return {object} The data to pass to the view's template.
         */
        serializeData: function () {
            var templateData = PropertiesView.prototype.serializeData.apply(this);
            var workflowName = this._workflowModel.get("name");
            var panelContext = {
                workflowName: workflowName,
                actionId: templateData.actionId
            };
            return _.extend(templateData, {
                additionalPanels: PanelService.renderPanels("workflow.transition.properties", panelContext),
                queryString: this._getQueryString()
            });
        }
    },

    /** @lends JIRA.WorkflowDesigner.PropertiesPanel.StatusPropertiesView */
    {
        /**
         * @param {Backbone.View} view View to check.
         * @return {boolean} Whether `view` is a transition view.
         */
        canHandleView: function (view) {
            return view instanceof GlobalTransitionView ||
                   view instanceof LoopedTransitionView ||
                   view instanceof TransitionView;
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView", null, require("workflow-designer/properties-panel/transition-properties-view"));