define("workflow-designer/selectable-figure-mixin", [], function() {
    /**
     * Draw2D figure selection capabilities for Backbone views. The view must:
     *
     * * store a reference to its {@link draw2d.Canvas} in a `_canvas` instance variable,
     * * implement a `_getFigure()` method that returns its primary {@link draw2d.Figure}, and
     * * implement `_onDeselect()` and `_onSelect()` methods that update in response to (de)selection.
     *
     * @mixin
     */
    return {
        /**
         * Deselect the view and its {@link draw2d.Figure}.
         */
        deselect: function () {
            if (this.isSelected()) {
                this._canvas.selectFigure(null);
            } else {
                this._onDeselect();
            }
        },

        /**
         * @return {boolean} Whether the view's figure is currently selected.
         */
        isSelected: function () {
            return this._canvas.getSelectedFigure() === this._getFigure();
        },

        /**
         * Select the view and its {@link draw2d.Figure}.
         */
        select: function () {
            if (this.isSelected()) {
                this._onSelect();
            } else {
                this._canvas.selectFigure(this._getFigure());
            }
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.SelectableFigureMixin", null, require("workflow-designer/selectable-figure-mixin"));