AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var D=require("workflow-designer/underscore");var G=require("jquery");var B=require("workflow-designer/analytics");var H=require("workflow-designer/workflow-model");var E=require("workflow-designer/transition-model");var F=require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");var C=require("workflow-designer/reuse-transition-form-view");var A=require("workflow-designer/test-utilities");module("ReuseTransitionFormView",{createView:function(J){var I;J=D.defaults({},J,{model:new E(),sourceStatuses:[{text:"Open",value:1}],targetStatuses:[{text:"Closed",value:2},{text:"Open",value:1}],workflowModel:this.createWorkflowModel()});I=new C(J);this.sandbox.spy(I.model,"set");I.$el.appendTo("#qunit-fixture");I.render();I.onShow();return I},createViewWithNoTransitions:function(){var I;I=this.createWorkflowModel();I.get("transitions").reset();return this.createView({workflowModel:I})},createWorkflowModel:function(){var J,I;I=new H({name:"Workflow"});J=I.get("statuses");J.add([{statusId:1,stepId:1},{statusId:2,stepId:2}]);I.get("transitions").add([{actionId:1,name:"Close",source:J.at(0),target:J.at(1)}]);return I},setup:function(){var I=this.sandbox=sinon.sandbox.create();this.addCommonTransitionDeferred=G.Deferred();this.addCommonTransitionStub=I.stub(F,"addCommonTransition").returns(this.addCommonTransitionDeferred)},teardown:function(){this.sandbox.restore()}});test("Changing the target status updates the transition field",function(){var I;I=this.createView();ok(I.ui.noTransitionsMessage.is(":hidden"),'The "no transitions" message is hidden');I.ui.targetStepId.val("1");I.ui.targetStepId.trigger("selected");ok(I.ui.noTransitionsMessage.is(":visible"),'The "no transitions" message is visible')});test("Clears the transition's angles on status change",function(){var J,I;J={sourceAngle:null,targetAngle:null};I=this.createView();I.ui.sourceStepId.trigger("selected");ok(I.model.set.getCall(0).calledWithExactly(J),"The transition's angles were cleared after changing the source status");I.ui.targetStepId.trigger("selected");ok(I.model.set.getCall(0).calledWithExactly(J),"The transition's angles were cleared after changing the target status")});test("Common transitions are squashed in the transition field",function(){var J,I,K;K=this.createWorkflowModel();K.get("transitions").add({actionId:1,name:"Close",source:K.get("statuses").at(1),target:K.get("statuses").at(1)});I=this.createView({workflowModel:K});J=I.ui.transitionId.find("option");equal(J.length,1,"The transition field has one option");equal(J.text(),"Close","The option's text is correct");equal(J.val(),"1","The option's value is correct")});test("Lists transitions in alphabetical order",function(){var J,K,I,L;J=[{text:"Close",value:"1"},{text:"Stay Closed",value:"2"}];L=this.createWorkflowModel();L.get("transitions").add({actionId:2,name:"Stay Closed",source:L.get("statuses").at(1),target:L.get("statuses").at(1)});I=this.createView({workflowModel:L});K=I.ui.transitionId.find("option").map(function(){var M=G(this);return{text:M.text(),value:M.val()}}).toArray();deepEqual(K,J,"The transitions are listed in alphabetical order")});test("Shows a message when there are no transitions to the selected target status",function(){var I=this.createViewWithNoTransitions();ok(I.$("#transition-id-single-select").is(":hidden"),"The transition ID field is not visible");ok(I.ui.noTransitionsMessage.is(":visible"),'The "no transitions" message is visible')});test("submit() rejects the returned deferred if there are no transitions to the target status",function(){var I=this.createViewWithNoTransitions().submit();equal(I.state(),"rejected","The returned promise was rejected")});test("submit() rejects the returned deferred on failure",function(){var I;I=this.createView().submit();this.addCommonTransitionDeferred.reject("Error");equal(I.state(),"rejected","The returned promise was rejected");I.fail(function(J){equal(J,"Error","It was rejected with the correct error message")})});test("submit() successfully reuses a transition",function(){var M,K,I,J,L;J=this.createView();L=J.options.workflowModel;this.sandbox.spy(B,"triggerAddCommonTransition");M={sourceStatusId:1,transitionId:1,workflowName:"Workflow"};K=L.get("transitions").at(0).omit("id","sourceAngle","targetAngle");K=D.extend(K,{source:L.get("statuses").at(0)});A.fill(J.el,{sourceStepId:1,targetStepId:2,transitionId:1});I=J.submit();equal(I.state(),"pending","The returned promise is pending");ok(this.addCommonTransitionStub.calledWithExactly(M),"WorkflowTransitionsAJAXManager.addCommonTransition was called with the correct arguments");this.addCommonTransitionDeferred.resolve();equal(I.state(),"resolved","The returned promise was resolved");equal(B.triggerAddCommonTransition.callCount,1,"An analytics event was triggered");sinon.assert.calledWith(B.triggerAddCommonTransition,L.get("permissions"));ok(J.model.set.calledWithExactly(K),"The correct attributes were set on the TransitionModel")});test("The initial transition isn't shown in the transition field",function(){var I,J;J=this.createWorkflowModel();J.get("statuses").at(0).set("initial",true);I=this.createView({workflowModel:J});equal(I.ui.transitionId.find("option").length,0,"The transitions field contains no options")});test('Triggers a "createNewTransition" event when the create new transition link is clicked',function(){var J=sinon.spy(),I;this.sandbox.stub(AJS,"format",function(){return Array.prototype.join.call(arguments,"")});I=this.createViewWithNoTransitions();I.on("createNewTransition",J);I.$(".create-new-transition").click();equal(J.callCount,1,"A createNewTransition event was triggered")})});