AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var G=require("jquery");var A=require("workflow-designer/test-utilities");var H=require("workflow-designer/workflow-model");var C=require("workflow-designer/permissions-model");var E=require("workflow-designer/transition-model");var D=require("workflow-designer/new-transition-form-view");var F=require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");var B=require("workflow-designer/io/ajax/workflow-looped-transitions-ajax-manager");module("NewTransitionFormView",{createView:function(J){var I;J=J||new C({editPropertyOptions:true,selectScreenOnTransition:true});I=new D({model:new E(),screens:[{text:"Screen",value:1}],sourceStatuses:[{text:"Open",value:2}],targetStatuses:[{text:"Closed",value:3}],workflowModel:new H({name:"Workflow",permissions:J})});this.sandbox.spy(I.model,"set");I.options.workflowModel.get("statuses").add([{stepId:2},{stepId:3}]);I.render();I.onShow();return I},setup:function(){var I=this.sandbox=sinon.sandbox.create();this.addTransitionDeferred=G.Deferred();this.addLoopedTransitionDeferred=G.Deferred();this.addTransitionStub=I.stub(F,"addTransition").returns(this.addTransitionDeferred);this.addLoopedTransitionStub=I.stub(B,"addLoopedTransition").returns(this.addLoopedTransitionDeferred)},teardown:function(){this.sandbox.restore()}});test("Clears the transition's angles on status change",function(){var J,I;J={sourceAngle:null,targetAngle:null};I=this.createView();I.ui.sourceStepId.trigger("selected");ok(I.model.set.getCall(0).calledWithExactly(J),"The transition's angles were cleared after changing the source status");I.ui.targetStepId.trigger("selected");ok(I.model.set.getCall(0).calledWithExactly(J),"The transition's angles were cleared after changing the target status")});test("submit() rejects the returned deferred on failure",function(){var I;I=this.createView().submit();this.addTransitionDeferred.reject("Error");equal(I.state(),"rejected","The returned promise was rejected");I.fail(function(J){equal(J,"Error","It was rejected with the correct error message")})});test("submit() successfully creates a new transition",function(){var L,K,I,J;J=this.createView();L={description:"Close the issue.",name:"Close",screenId:1,sourceStepId:2,targetStepId:3,workflowName:"Workflow"};K={description:"Close the issue.",name:"Close",screenId:1,screenName:"Screen",global:false,globalTransition:false,looped:false,loopedTransition:false,source:J.options.workflowModel.get("statuses").at(0),target:J.options.workflowModel.get("statuses").at(1)};A.fill(J.el,{"#transition-description":"Close the issue.","#transition-name":"Close","#transition-screen-id":1,"#transition-source-step-id":2,"#transition-target-step-id":3});I=J.submit();equal(I.state(),"pending","The returned promise is pending");ok(this.addTransitionStub.calledWithExactly(L),"WorkflowTransitionsAJAXManager.addTransition was called with the correct arguments");this.addTransitionDeferred.resolve({global:false,looped:false});equal(I.state(),"resolved","The returned promise was resolved");ok(J.model.set.calledWithExactly(K),"The correct attributes were set on the TransitionModel")});test("submit() successfully creates a new looped transition",function(){var L,K,I,J;J=this.createView();L={description:"Close the issue.",name:"Close",screenId:1,sourceStepId:-65536,targetStepId:-65537,workflowName:"Workflow"};K={description:"Close the issue.",global:false,globalTransition:false,looped:true,loopedTransition:true,name:"Close",screenId:1,screenName:"Screen",source:undefined,target:undefined};A.fill(J.el,{"#transition-description":"Close the issue.","#transition-name":"Close","#transition-screen-id":1,"#transition-source-step-id":-65536,"#transition-target-step-id":-65537});I=J.submit();equal(I.state(),"pending","The returned promise is pending");ok(this.addLoopedTransitionStub.calledWithExactly(L),"WorkflowTransitionsAJAXManager.addTransition was called with the correct arguments");this.addLoopedTransitionDeferred.resolve({global:false,looped:true});equal(I.state(),"resolved","The returned promise was resolved");ok(J.model.set.calledWithExactly(K),"The correct attributes were set on the TransitionModel for a looped transition")});test("When user has screen permission then Screen select is present",function(){var I=this.createView();equal(I.$el.find("#transition-screen-id").length,1,"Screen select should be present")});test("When user doesn't have screen permission then no Screen select is present",function(){var I=this.createView(new C({selectScreenOnTransition:false}));equal(I.$el.find("#transition-screen-id").length,0,"No screen select should be present")});test("When user doesn't have screen permission 0 is submitted as screenid",function(){var L,K,I,J;J=this.createView(new C({selectScreenOnTransition:false}));L={description:"Close the issue.",name:"Close",screenId:0,sourceStepId:2,targetStepId:3,workflowName:"Workflow"};K={description:"Close the issue.",name:"Close",screenId:0,screenName:"",global:false,globalTransition:false,looped:false,loopedTransition:false,source:J.options.workflowModel.get("statuses").at(0),target:J.options.workflowModel.get("statuses").at(1)};A.fill(J.el,{"#transition-description":"Close the issue.","#transition-name":"Close","#transition-screen-id":1,"#transition-source-step-id":2,"#transition-target-step-id":3});I=J.submit();equal(I.state(),"pending","The returned promise is pending");ok(this.addTransitionStub.calledWithExactly(L),"WorkflowTransitionsAJAXManager.addTransition was called with the correct arguments");this.addTransitionDeferred.resolve({global:false,looped:false});equal(I.state(),"resolved","The returned promise was resolved");ok(J.model.set.calledWithExactly(K),"The correct attributes were set on the TransitionModel")})});