AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StatusDialogView = require("workflow-designer/dialogs/status-dialog-view");
    var StatusCategoriesAJAXManager = require("workflow-designer/io/ajax/status-categories-ajax-manager");
    var StatusCategorySingleSelect = JIRA.StatusCategorySingleSelect;
    var WorkflowModel = require("workflow-designer/workflow-model");
    var StatusModel = require("workflow-designer/status-model");
    var Messages = require("workflow-designer/messages");
    var JIRADialog = require("jira/dialog/dialog");
    var Templates = require("workflow-designer/templates");
    var jQuery = require("jquery");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("StatusDialogView", {
        setup: function () {
            var sandbox = this.sandbox = sinon.sandbox.create(),
                statusCategories;

            statusCategories = [{
                colorName: "medium-gray",
                id: 1,
                key: "undefined",
                name: "No Category"
            }, {
                colorName: "blue-gray",
                id: 2,
                key: "new",
                name: "New"
            }, {
                colorName: "green",
                id: 3,
                key: "done",
                name: "Complete"
            }];

            this.getStatusCategoriesStub = sandbox.stub(StatusCategoriesAJAXManager, "getStatusCategories").returns(jQuery.Deferred().resolve(statusCategories));
            this.statusCategories = statusCategories;
            this.statusCategorySingleSelectSpy = sandbox.spy(StatusCategorySingleSelect.prototype, "init");
        },

        /**
         * Show a `StatusDialogView`.
         *
         * @param {object} options Option to pass to the constructor.
         * @returns {jQuery} The dialog's element.
         */
        showDialog: function (options) {
            var Dialog;

            Dialog = StatusDialogView.extend({
                _onError: jQuery.noop,
                _onSuccess: jQuery.noop,

                template: function (options) {
                    _.extend(options, {
                        submitText: "Submit",
                        title: "Title"
                    });

                    return Templates.statusDialog(options);
                }
            });

            options = _.defaults({}, options, {
                workflowModel: new WorkflowModel(),
                statusModel: new StatusModel()
            });

            new Dialog(options).show();
            return JIRADialog.current && JIRADialog.current.get$popup();
        },

        teardown: function () {
            TestUtilities.removeDialogs();
            this.sandbox.restore();
        }
    });

    test("Shows a status category field", function () {
        var element,
            getStatusCategoriesDeferred = jQuery.Deferred();

        this.getStatusCategoriesStub.returns(getStatusCategoriesDeferred);

        element = this.showDialog();
        ok(!element.is(":visible"), "The dialog isn't visible");
        equal(this.getStatusCategoriesStub.callCount, 1, "StatusCategoriesAJAXManager.getStatusCategories was called");

        getStatusCategoriesDeferred.resolve(this.statusCategories);
        equal(element.find("#status-category-id").length, 1, "The dialog contains a status category field");
        ok(element.is(":visible"), "The dialog is visible");
        equal(this.statusCategorySingleSelectSpy.callCount, 1, "A StatusCategorySingleSelect was created");
    });

    test("Shows an error message on failure to retrieve status categories", function () {
        var hideSpy = this.sandbox.spy(StatusDialogView.prototype, "hide"),
            showErrorMessageStub = this.sandbox.stub(Messages, "showErrorMessage");

        this.getStatusCategoriesStub.returns(jQuery.Deferred().reject("Nope!"));
        this.showDialog();

        equal(hideSpy.callCount, 1, "The dialog was hidden");
        equal(showErrorMessageStub.callCount, 1, "Messages.showErrorMessage was called");
        deepEqual(showErrorMessageStub.args[0], ["Nope!"], "It was passed the correct arguments");
    });

    test("The status category field doesn't contain the undefined category", function () {
        equal(this.showDialog().find("#status-category-id option[value=1]").length, 0,
            "The status category field doesn't contain the undefined category");
    });

    test("The status category field is populated with the status's category", function () {
        var element;

        element = this.showDialog({
            statusModel: new StatusModel({
                statusCategory: {
                    id: 3
                }
            })
        });

        equal(element.find("#status-category-id :selected").val(), "3",
            "The correct status category is selected");
    });

});
