AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var G=require("workflow-designer/canvas-model");var D=require("workflow-designer/transition-view");var H=require("workflow-designer/status-view");var E=require("workflow-designer/workflow-model");var A=require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");var B=require("workflow-designer/dialogs/edit-transition-source-dialog-view");var C=require("jira/dialog/dialog");var F=require("workflow-designer/test-utilities");var I=require("jquery");module("EditTransitionSourceDialogView",{setup:function(){this.canvas=F.testDraw2DCanvas();this.sandbox=sinon.sandbox.create();this.updateTransitionSourceStub=this.sandbox.stub(A,"updateTransitionSource");this.createWorkflowModel();this.createStatusModelsAndViews();this.createTransitionModelsAndViews()},createWorkflowModel:function(){this.workflowModel=new E({name:"Workflow Name"});this.workflowModel.updateTransitionSource=this.sandbox.spy()},createStatusModelsAndViews:function(){this.originalSourceStatus=this.workflowModel.addStatus({stepId:1,name:"Source"});this.sourceView=new H({canvas:this.canvas,model:this.originalSourceStatus,workflowModel:this.workflowModel}).render();this.targetView=new H({canvas:this.canvas,model:this.workflowModel.addStatus({stepId:2,name:"Target"}),workflowModel:this.workflowModel}).render();this.newSourceView=new H({canvas:this.canvas,model:this.workflowModel.addStatus({stepId:3,name:"New source"}),workflowModel:this.workflowModel}).render();this.sourcePort=this.newSourceView.getPorts()[0]},createTransitionModelsAndViews:function(){this.transitionModel=this.workflowModel.addTransition({actionId:1,source:this.sourceView.model,target:this.targetView.model,targetAngle:90});this.transitionView=new D({canvas:this.canvas,canvasModel:new G({},{workflowModel:this.workflowModel}),model:this.transitionModel,sourceView:this.sourceView,targetView:this.targetView,workflowModel:this.workflowModel}).render();this.transitionView.resetConnection=this.sandbox.spy()},showDialog:function(){new B({newSourcePort:this.sourcePort,newSourceView:this.newSourceView,originalSourceStatus:this.originalSourceStatus,transitionView:this.transitionView,workflowModel:this.workflowModel}).show();return C.current&&C.current.get$popup()},teardown:function(){F.removeDialogs();this.sandbox.restore()}});test("Editing transition source",function(){var J=I.Deferred(),K=this.showDialog(),L=this.newSourceView.getAngleToPort(this.sourcePort);ok(F.dialogIsVisible(),"The dialog is visible");ok(K.find(":submit").length,"The dialog has a submit button");this.updateTransitionSourceStub.returns(J.promise());F.submit(K);equal(K.find(":input:disabled").length,K.find(":input").length,"All inputs are disabled while submitting");equal(this.updateTransitionSourceStub.callCount,1,"WorkflowTransitionsAJAXManager.updateTransitionSource() was called");J.resolve();equal(this.workflowModel.updateTransitionSource.callCount,1,"WorkflowModel.updateTransitionSource was called");deepEqual(this.workflowModel.updateTransitionSource.args[0][0],{transition:this.transitionModel,sourceAngle:L,sourceStepId:3},"It was passed the correct arguments");ok(!F.dialogIsVisible(),"The dialog closed")});test("An error message is shown if updating the transition source fails",function(){var L=this.showDialog(),J,K="Oh noes!";this.updateTransitionSourceStub.returns(I.Deferred().reject(K).promise());F.submit(L);J=L.find(".aui-message.error");equal(J.length,1,"An error message is shown in the dialog");ok(J.text().indexOf(K)>-1,"It contains the correct text");equal(L.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateTransitionSourceStub.returns(I.Deferred().promise());F.submit(L);equal(L.find(".error").length,0,"Errors are removed on submit")});test("Closing the dialog resets transition target",function(){var J=this.showDialog();ok(F.dialogIsVisible(),"The dialog is visible");J.find("#cancel").click();equal(this.transitionView.resetConnection.callCount,1,"Transition target was reset");ok(!F.dialogIsVisible(),"The dialog closed")})});