AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var I=require("jquery");var H=require("workflow-designer/io/ajax/screens-ajax-manager");var A=require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");var D=require("workflow-designer/workflow-model");var F=require("workflow-designer/dialogs/edit-transition-dialog-view");var G=require("workflow-designer/analytics");var C=require("jira/dialog/dialog");var E=require("workflow-designer/test-utilities");var B=require("workflow-designer/permissions-model");module("EditTransitionDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.getScreensStub=this.sandbox.stub(H,"getScreens");this.getScreensStub.returns(I.Deferred().resolve([{id:1,name:"Screen"}]).promise());this.updateTransitionStub=this.sandbox.stub(A,"updateTransition");this.workflowModel=new D({name:"Workflow Name",permissions:new B({editPropertyOptions:true,selectScreenOnTransition:true})})},showDialog:function(){this.transitionModel=this.workflowModel.addTransition({actionId:"1",description:"This is a description.",name:"Transition",source:this.workflowModel.addStatus({id:100,stepId:1}),target:this.workflowModel.addStatus({id:200,stepId:2})});new F({transitionModel:this.transitionModel,workflowModel:this.workflowModel}).show();return C.current&&C.current.get$popup()},teardown:function(){E.removeDialogs();this.sandbox.restore()}});test("An error message is shown if editing the transition fails",function(){var L=this.showDialog(),J,K="Oh noes!";this.updateTransitionStub.returns(I.Deferred().reject(K).promise());E.submit(L);J=L.find(".aui-message.error");equal(J.length,1,"An error message is shown in the dialog");ok(J.text().indexOf(K)>-1,"It contains the correct text");equal(L.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateTransitionStub.returns(I.Deferred().promise());E.submit(L);equal(L.find(".error").length,0,"Errors are removed on submit")});test("Doesn't contain source or target fields",function(){var J=this.showDialog();equal(J.find("#transition-source-step-id").length,0,"The dialog doesn't contain a source field");equal(J.find("#transition-target-step-id").length,0,"The dialog doesn't contain a target field")});test("Editing a single transition",function(){var K,J=I.Deferred(),M=this.showDialog(),N,L;this.updateTransitionStub.returns(J.promise());this.sandbox.stub(G,"triggerUpdateTransition");E.submit(M,{"#transition-description":"Awesome new description!","#transition-name":"New Name"});equal(M.find(":input:disabled").length,M.find(":input").length,"All inputs are disabled while submitting");equal(this.updateTransitionStub.callCount,1,"TransitionsAJAXManager.updateTransition() was called");J.resolve(100);K=this.workflowModel.get("transitions").at(0).attributes;L={description:"Awesome new description!",name:"New Name"};deepEqual(_.pick(K,_.keys(L)),L,"The TransitionModel's attributes were updated");N={description:"Awesome new description!",name:"New Name",screenId:1,sourceStepId:1,transitionId:"1",workflowName:"Workflow Name"};deepEqual(this.updateTransitionStub.args[0][0],N,"The correct arguments were passed to the AJAX Manager");ok(G.triggerUpdateTransition.calledOnce,"Analytics event for update/transition has been triggered");sinon.assert.calledWith(G.triggerUpdateTransition,this.workflowModel.get("permissions"))});test("Editing common transitions",function(){var K,J=I.Deferred(),M=this.showDialog(),N,L;this.workflowModel.addTransition({actionId:"1",description:"This is a description.",name:"Transition",source:this.workflowModel.addStatus({id:300,stepId:3}),target:this.workflowModel.addStatus({id:200,stepId:2})});this.updateTransitionStub.returns(J.promise());this.sandbox.stub(G,"triggerUpdateTransition");E.submit(M,{"#transition-description":"Awesome new description!","#transition-name":"New Name"});equal(M.find(":input:disabled").length,M.find(":input").length,"All inputs are disabled while submitting");equal(this.updateTransitionStub.callCount,1,"TransitionsAJAXManager.updateTransition() was called");J.resolve(100);K=this.workflowModel.get("transitions").at(0).attributes;L={description:"Awesome new description!",name:"New Name"};deepEqual(_.pick(K,_.keys(L)),L,"The TransitionModel's attributes were updated");K=this.workflowModel.get("transitions").at(1).attributes;L={description:"Awesome new description!",name:"New Name"};deepEqual(_.pick(K,_.keys(L)),L,"The common TransitionModel's attributes were updated");N={description:"Awesome new description!",name:"New Name",screenId:1,sourceStepId:1,transitionId:"1",workflowName:"Workflow Name"};deepEqual(this.updateTransitionStub.args[0][0],N,"The correct arguments were passed to the AJAX Manager");ok(G.triggerUpdateTransition.calledOnce,"Analytics event for update/transition has been triggered")});test("Fields are populated with the transition's attributes",function(){var J=this.showDialog();equal(J.find("#transition-description").val(),this.transitionModel.get("description"),"The transition's description was used");equal(J.find("#transition-name").val(),this.transitionModel.get("name"),"The transition's name was used")});test("When no screen permission no rest call is made to screen rest endpoint",function(){this.workflowModel.get("permissions").set({selectScreenOnTransition:false});this.showDialog();sinon.assert.notCalled(this.getScreensStub,"No rest call is made for screens")});test("When there is screen permission rest call is made to screen rest endpoint",function(){this.showDialog();sinon.assert.calledOnce(this.getScreensStub,"Rest call is made for screens")});test("When no screen permission no screen select should be present",function(){this.workflowModel.get("permissions").set({selectScreenOnTransition:false});var J=this.showDialog();equal(J.find("#transition-screen-id").length,0,"No screen permission select should be present")});test("When there is screen permission screen select should be present",function(){var J=this.showDialog();equal(J.find("#transition-screen-id").length,1,"Screen permission select should be present")})});