define("workflow-designer/dialogs/edit-status-dialog-view", [
    "workflow-designer/io/ajax/workflow-statuses-ajax-manager",
    "workflow-designer/messages",
    "workflow-designer/io/ajax/statuses-ajax-manager",
    "workflow-designer/dialogs/status-dialog-view",
    "workflow-designer/analytics",
    "workflow-designer/templates",
    "workflow-designer/backbone",
    "workflow-designer/underscore",
    "jquery"
], function(
    WorkflowStatusesAJAXManager,
    Messages,
    StatusesAJAXManager,
    StatusDialogView,
    Analytics,
    Templates,
    Backbone,
    _,
    jQuery
) {
    /**
     * @class JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView
     * @classdesc The workflow designer's "Edit Status" dialog.
     * @extends JIRA.WorkflowDesigner.Dialogs.StatusDialogView
     */
    return StatusDialogView.extend (
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView# */
    {
        id: "edit-status-dialog",

        template: Templates.editStatusDialog,

        /**
         * This method first retrieves status information so we can display an
         * "editing this status will affect other workflows" warning if needed.
         *
         * @returns {function} A function that retrieves the dialog's content.
         * @private
         */
        _getContent: function () {
            var getContent = StatusDialogView.prototype._getContent.apply(this),
                instance = this;

            return function (callback) {
                var associatedWorkflowsRequest = StatusesAJAXManager.getNumberOfAssociatedWorkflows(instance._statusModel.get("statusId")),
                    request,
                    statusesRequest = StatusesAJAXManager.getStatuses();

                request = jQuery.when(associatedWorkflowsRequest, statusesRequest);
                request.done(function (numberOfWorkflows, statuses) {
                    instance._numberOfAssociatedWorkflows = numberOfWorkflows;
                    instance._statuses = statuses;
                    getContent(callback);
                });

                request.fail(function (errorMessage) {
                    Messages.showErrorMessage(errorMessage);
                    instance.hide();
                });
            };
        },

        /**
         * @private
         * @returns {null|object} The selected status category or `null`.
         */
        _getSelectedStatusCategory: function () {
            var option = this.ui.statusCategoryId.find(":selected");
            return !option.length ? null : {
                colourName: option.data("color-name"),
                id: Number(option.val())
            };
        },

        /**
         * Make a request to update the status.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            options = _.extend({}, options, {
                statusId: this._statusModel.get("statusId")
            });

            return WorkflowStatusesAJAXManager.updateStatus(options);
        },

        /**
         * @private
         */
        _onSuccess: function () {
            var attributes;

            attributes = {
                description: this.ui.description.val(),
                name: this.ui.name.val(),
                statusCategory: this._getSelectedStatusCategory()
            };

            Analytics.triggerUpdateStatus(this._workflowModel.get("permissions"));
            Analytics.triggerUpdateStep(this._workflowModel.get("permissions"));
            this.hide();
            this._statusModel.set(attributes);
        },

        serializeData: function () {
            var data = StatusDialogView.prototype.serializeData.apply(this, arguments);
            return _.extend(data, {numberOfWorkflows: this._numberOfAssociatedWorkflows});
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView", null, require("workflow-designer/dialogs/edit-status-dialog-view"));