define("workflow-designer/dialogs/edit-looped-transition-dialog-view", [
    "workflow-designer/dialogs/edit-transition-dialog-view",
    "workflow-designer/io/ajax/workflow-looped-transitions-ajax-manager",
    "workflow-designer/analytics"
], function(
    EditTransitionDialogView,
    WorkflowLoopedTransitionsAJAXManager,
    Analytics
) {
    /**
     * @class JIRA.WorkflowDesigner.Dialogs.EditLoopedTransitionDialogView
     * @classdesc The workflow designer's "Edit Looped Transition" dialog.
     * @extends JIRA.WorkflowDesigner.Dialogs.TransitionDialogView
     */
    return EditTransitionDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditLoopedTransitionDialogView# */
    {
        id: "edit-looped-transition-dialog",

        /**
         * Make a request to update the looped transition.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            return WorkflowLoopedTransitionsAJAXManager.updateLoopedTransition(options);
        },

        /**
         * Trigger an analytics event indicating that the update was successful.
         *
         * @protected
         */
        _triggerAnalyticsEvent: function () {
            Analytics.triggerUpdateLoopedTransition(this._workflowModel.get("permissions"));
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Dialogs.EditLoopedTransitionDialogView", null, require("workflow-designer/dialogs/edit-looped-transition-dialog-view"));