AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var F=require("workflow-designer/io/ajax/screens-ajax-manager");var C=require("workflow-designer/io/ajax/workflow-global-transitions-ajax-manager");var H=require("workflow-designer/workflow-model");var G=require("workflow-designer/dialogs/edit-global-transition-dialog-view");var D=require("workflow-designer/analytics");var B=require("jira/dialog/dialog");var A=require("workflow-designer/test-utilities");var E=require("workflow-designer/underscore");module("EditTransitionDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.getScreensStub=this.sandbox.stub(F,"getScreens");this.getScreensStub.returns(jQuery.Deferred().resolve([{id:1,name:"Screen"}]).promise());this.updateGlobalTransitionStub=this.sandbox.stub(C,"updateGlobalTransition");this.workflowModel=new H({name:"Workflow Name"});this.workflowModel.get("permissions").set({selectScreenOnTransition:true})},showDialog:function(){this.transitionModel=this.workflowModel.addTransition({actionId:"1",description:"This is a description.",name:"Transition",globalTransition:true,source:this.workflowModel.addStatus({stepId:2}),target:this.workflowModel.addStatus({stepId:2})});new G({transitionModel:this.transitionModel,workflowModel:this.workflowModel}).show();return B.current&&B.current.get$popup()},teardown:function(){A.removeDialogs();this.sandbox.restore()}});test("An error message is shown if editing the global transition fails",function(){var K=this.showDialog(),I,J="Oh noes!";this.updateGlobalTransitionStub.returns(jQuery.Deferred().reject(J).promise());A.submit(K);I=K.find(".aui-message.error");equal(I.length,1,"An error message is shown in the dialog");ok(I.text().indexOf(J)>-1,"It contains the correct text");equal(K.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateGlobalTransitionStub.returns(jQuery.Deferred().promise());A.submit(K);equal(K.find(".error").length,0,"Errors are removed on submit")});test("Editing a global transition",function(){var J,I=jQuery.Deferred(),L=this.showDialog(),K;this.updateGlobalTransitionStub.returns(I.promise());this.sandbox.stub(D,"triggerUpdateGlobalTransition");A.submit(L,{"#transition-description":"Awesome new description!","#transition-name":"New Name","#transition-screen-id":1});equal(L.find(":input:disabled").length,L.find(":input").length,"All inputs are disabled while submitting");equal(this.updateGlobalTransitionStub.callCount,1,"GlobalTransitionsAJAXManager.updateGlobalTransition() was called");I.resolve(100);J=this.workflowModel.get("transitions").at(0).attributes;K={description:"Awesome new description!",name:"New Name",screenId:1};deepEqual(E.pick(J,E.keys(K)),K,"The global TransitionModel's attributes were updated");ok(D.triggerUpdateGlobalTransition.calledOnce,"Analytics event for update/globaltransition has been triggered");sinon.assert.calledWith(D.triggerUpdateGlobalTransition,this.workflowModel.get("permissions"))});test("Fields are populated with the global transition's attributes",function(){var I=this.showDialog();equal(I.find("#transition-description").val(),this.transitionModel.get("description"),"The transition's description was used");equal(I.find("#transition-name").val(),this.transitionModel.get("name"),"The transition's name was used")})});